package org.findmykids.geo.common.extensions


fun ByteArray.getShortAt(index: Int) =
    (((this[index].toInt() and 0xFF) shl 8) or
            (this[index + 1].toInt() and 0xFF)).toShort()

//fun ByteArray.getIntAt(index: Int) =
//    ((this[index].toInt() and 0xFF) shl 24) or
//            ((this[index + 1].toInt() and 0xFF) shl 16) or
//            ((this[index + 2].toInt() and 0xFF) shl 8) or
//            (this[index + 3].toInt() and 0xFF)

fun ByteArray.getLongAt(index: Int) =
    ((this[index].toLong() and 0xFF) shl 56) or
            ((this[index + 1].toLong() and 0xFF) shl 48) or
            ((this[index + 2].toLong() and 0xFF) shl 40) or
            ((this[index + 3].toLong() and 0xFF) shl 32) or
            ((this[index + 4].toLong() and 0xFF) shl 24) or
            ((this[index + 5].toLong() and 0xFF) shl 16) or
            ((this[index + 6].toLong() and 0xFF) shl 8) or
            (this[index + 7].toLong() and 0xFF)