package org.findmykids.geo.common.di.session.module

import dagger.Module
import dagger.Provides
import org.findmykids.geo.api.extensions.GeoExtensions
import org.findmykids.geo.common.di.session.SessionScope
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.db.GeoDatabase
import org.findmykids.geo.data.network.SocketClient
import org.findmykids.geo.data.network.YandexApi
import org.findmykids.geo.data.preferences.LocalPreferences
import org.findmykids.geo.data.repository.storage.configuration.ConfigurationRepository
import org.findmykids.geo.data.repository.storage.configuration.ConfigurationRepositoryImpl
import org.findmykids.geo.data.repository.storage.currentSession.CurrentSessionRepository
import org.findmykids.geo.data.repository.storage.currentSession.CurrentSessionRepositoryImpl
import org.findmykids.geo.data.repository.storage.error.ErrorRepository
import org.findmykids.geo.data.repository.storage.error.ErrorRepositoryImpl
import org.findmykids.geo.data.repository.storage.geo.GeoRepository
import org.findmykids.geo.data.repository.storage.geo.GeoRepositoryImpl
import org.findmykids.geo.data.repository.storage.request.RequestRepository
import org.findmykids.geo.data.repository.storage.request.RequestRepositoryImpl
import org.findmykids.geo.data.repository.storage.yandexLocator.YandexLocatorRepository
import org.findmykids.geo.data.repository.storage.yandexLocator.YandexLocatorRepositoryImpl
import org.findmykids.geo.data.repository.storage.zones.ZonesRepository
import org.findmykids.geo.data.repository.storage.zones.ZonesRepositoryImpl


@Module(includes = [DBModule::class, NetworkModule::class])
internal class DataStorageModule {
    init {
        Logger.d().print()
    }


    @Provides
    @SessionScope
    fun provideCurrentSessionRepository(
        localPreferences: LocalPreferences
    ): CurrentSessionRepository = CurrentSessionRepositoryImpl(
        localPreferences
    )

    @Provides
    @SessionScope
    fun provideGeoRepository(
        socketClient: SocketClient,
        geoDatabase: GeoDatabase,
        geoExtensions: GeoExtensions,
        localPreferences: LocalPreferences
    ): GeoRepository = GeoRepositoryImpl(
        socketClient,
        geoDatabase,
        geoExtensions,
        localPreferences
    )

    @Provides
    @SessionScope
    fun provideErrorRepository(
        socketClient: SocketClient,
        geoDatabase: GeoDatabase
    ): ErrorRepository = ErrorRepositoryImpl(
        socketClient,
        geoDatabase
    )

    @Provides
    @SessionScope
    fun provideRequestRepository(
        socketClient: SocketClient
    ): RequestRepository = RequestRepositoryImpl(
        socketClient
    )

    @Provides
    @SessionScope
    fun provideConfigurationRepository(
        geoDatabase: GeoDatabase
    ): ConfigurationRepository = ConfigurationRepositoryImpl(
        geoDatabase
    )

    @Provides
    @SessionScope
    fun provideYandexLocatorRepository(
        yandexApi: YandexApi
    ): YandexLocatorRepository = YandexLocatorRepositoryImpl(
        yandexApi
    )

    @Provides
    @SessionScope
    fun provideZonesRepository(
        geoDatabase: GeoDatabase
    ): ZonesRepository = ZonesRepositoryImpl(
        geoDatabase
    )
}