package org.findmykids.geo.common.di.session.module

import android.content.Context
import androidx.room.Room
import androidx.room.RoomDatabase
import dagger.Module
import dagger.Provides
import org.findmykids.geo.common.di.session.SessionScope
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.db.GeoDatabase


@Module
internal class DBModule(
    private val mContext: Context
) {

    private val mDB: GeoDatabase by lazy {
        Room.databaseBuilder(mContext.applicationContext, GeoDatabase::class.java, "GeoDatabase")
            .setJournalMode(RoomDatabase.JournalMode.TRUNCATE)
            .fallbackToDestructiveMigration()
            .build()
    }


    init {
        Logger.d().print()
    }


    override fun toString(): String = ""


    @Provides
    @SessionScope
    fun provideGeoDatabase(): GeoDatabase = mDB
}