package org.findmykids.geo.common.di.root.module

import android.content.Context
import android.content.SharedPreferences
import dagger.Module
import dagger.Provides
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.preferences.LocalPreferences
import org.findmykids.geo.data.preferences.LocalPreferencesImpl
import org.findmykids.geo.data.repository.storage.authorisation.AuthorisationRepository
import org.findmykids.geo.data.repository.storage.authorisation.AuthorisationRepositoryImpl
import org.findmykids.geo.domain.authorization.AuthorizationInteractor
import org.findmykids.geo.domain.authorization.AuthorizationInteractorImpl
import javax.inject.Singleton


@Module
internal class AuthorityModule {
    init {
        Logger.d().print()
    }


    @Provides
    @Singleton
    fun provideSharedPreferences(
        context: Context
    ): SharedPreferences = context
        .getSharedPreferences(SHARED_PREFERENCES_NAME, Context.MODE_PRIVATE)

    @Provides
    @Singleton
    fun provideLocalPreferences(
        sharedPreferences: SharedPreferences
    ): LocalPreferences = LocalPreferencesImpl(
        sharedPreferences
    )

    @Provides
    @Singleton
    fun provideAuthorisationRepository(
        localPreferences: LocalPreferences
    ): AuthorisationRepository = AuthorisationRepositoryImpl(
        localPreferences
    )

    @Provides
    @Singleton
    fun provideAuthorizationInteractor(
        authorisationRepository: AuthorisationRepository
    ): AuthorizationInteractor = AuthorizationInteractorImpl(
        authorisationRepository
    )


    companion object {
        private const val SHARED_PREFERENCES_NAME = "GeoSharedPreferences"
    }
}