package org.findmykids.geo.presentation.session.input

import io.reactivex.Observable
import org.findmykids.geo.domain.model.Command


/**
 * Обработчик команд. Он решает запускать или остановить лайв режим (гео, сенсору, способы движения и т.д.)
 */
internal interface CommandFrontController {
    /**
     * Обработчик команды. Возвращает пары значений:
     * 1 - запускать или остановить лайв режим
     * 2 - сколько осталось еще сообщения после текущего (сделано чтобы понимать что текущая команда полностью обработана)
     */
    fun add(command: Command): Observable<Pair<Boolean, Int>>
}