package org.findmykids.geo.presentation.session

import android.app.job.JobParameters
import android.app.job.JobService
import android.os.Build
import org.findmykids.geo.common.logger.Logger


/**
 * Накапливает джобы чтобы централизовано все остановить, когда сессия будет завершаться
 */
class StartedJobs {
    private val mJobs = mutableListOf<Pair<JobService, JobParameters>>()


    fun addJob(jobService: JobService, parameters: JobParameters) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Logger.d().addArg(jobService::class.simpleName).print()
            mJobs.add(Pair(jobService, parameters))
        }
    }

    fun stopJobs() {
        Logger.d().addArg(mJobs.size).print()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            mJobs.forEach { (jobService, parameters) ->
                jobService.jobFinished(parameters, false)
            }
            mJobs.clear()
        }
    }
}