package org.findmykids.geo.domain.subscriber.station

import io.reactivex.Completable
import org.findmykids.geo.data.model.Location
import org.findmykids.geo.data.repository.trigger.station.StationManager
import org.findmykids.geo.data.repository.storage.configuration.ConfigurationRepository
import javax.inject.Inject


internal class StationSubscriberInteractorImpl @Inject constructor(
    private val mStationManager: StationManager,
    private val mConfigurationRepository: ConfigurationRepository
) : StationSubscriberInteractor {

    override fun toString(): String = ""

    override fun subscribe(location: Location): Completable = mConfigurationRepository
        .get()
        .flatMapCompletable { mStationManager.subscribe(location, it.stationConfiguration) }

    override fun unsubscribe(): Completable = mStationManager
        .unsubscribe()
}