package org.findmykids.geo.data.repository.trigger.task

import android.content.ContentProvider
import android.content.ContentResolver
import android.content.ContentValues
import android.content.Intent
import android.database.Cursor
import android.database.MatrixCursor
import android.net.Uri
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.presentation.session.SessionService


internal class TasksProvider : ContentProvider() {

    override fun toString(): String = ""

    override fun onCreate(): Boolean {
        Logger.d().print()
        return true
    }

    override fun getType(uri: Uri): String? =
        ContentResolver.CURSOR_ITEM_BASE_TYPE + "/vnd." + NAME + ".item"

    override fun query(
        uri: Uri,
        projection: Array<out String>?,
        selection: String?,
        selectionArgs: Array<out String>?,
        sortOrder: String?
    ): Cursor? {
        Logger.d().print()
        val task = Tasks.valueOf(selection!!)
        val intent = Intent(context, SessionService::class.java).apply {
            action = task.name
            when (task) {
                Tasks.ACTIVATE -> {
                    putExtra(Tasks.BASE_URL, selectionArgs!![0])
                    putExtra(Tasks.API_KEY, selectionArgs[1].toCharArray())
                    putExtra(Tasks.USER_TOKEN, selectionArgs[2].toCharArray())
                    putExtra(Tasks.USER_ID, selectionArgs[3].toCharArray())
                }
                Tasks.REAL_TIME -> {
                    putExtra(Tasks.REAL_TIME_ENABLED, selectionArgs!![0].toBoolean())
                }
                else -> {
                }
            }
        }
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
            context?.startForegroundService(intent)
        } else {
            context?.startService(intent)
        }
        val cursor = MatrixCursor(arrayOf("value"))
        val rowBuilder = cursor.newRow()
        rowBuilder.add("1")
        return cursor
    }

    override fun insert(uri: Uri, values: ContentValues?): Uri? =
        throw NotImplementedError()

    override fun update(uri: Uri, values: ContentValues?, selection: String?, selectionArgs: Array<out String>?): Int =
        throw NotImplementedError()

    override fun delete(uri: Uri, selection: String?, selectionArgs: Array<out String>?): Int =
        throw NotImplementedError()


    companion object {
        const val NAME = "TasksProvider"
    }
}