package org.findmykids.geo.data.repository.storage.geo

import io.reactivex.Completable
import io.reactivex.Single
import org.findmykids.geo.common.Container
import org.findmykids.geo.data.model.Configuration
import org.findmykids.geo._todo.Geo
import org.findmykids.geo.data.model.GeoLocation
import org.findmykids.geo.data.model.Session


internal interface GeoRepository {
    fun sendGeo(geo: Geo): Completable


    fun saveGeoLocation(geoLocation: GeoLocation): Completable

    fun getLastSaveGeoLocation(): Single<Container<GeoLocation>>


    fun sendGeoLocation(geoLocation: GeoLocation, reason: String): Completable

    fun getLastSendGeoLocation(): Single<Container<GeoLocation>>


    fun sendAll(session: Session, configuration: Configuration.GeoStorageConfiguration): Completable

    fun clear(): Completable
}