package org.findmykids.geo.data.repository.live.battery

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.os.Handler
import android.os.HandlerThread
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.Configuration
import javax.inject.Inject


internal class BatteryRepositoryImpl @Inject constructor(
    private val mContext: Context
) : BatteryRepository() {

    private val mBroadcastReceiver: BroadcastReceiver = object : BroadcastReceiver() {
        override fun onReceive(context: Context, intent: Intent) {
            sendEvent(BatteryEvent(BatteryFactory.create(intent)))
        }
    }


    override fun toString(): String = ""

    override fun start(configuration: Configuration.BatteryDataConfiguration, handlerThread: HandlerThread) {
        Logger.i().addArg(configuration).print()
        mContext.registerReceiver(null, IntentFilter(Intent.ACTION_BATTERY_CHANGED))?.let {
            sendEvent(BatteryEvent(BatteryFactory.create(it)))
        }
        mContext.registerReceiver(mBroadcastReceiver, IntentFilter(Intent.ACTION_BATTERY_CHANGED), null, Handler(handlerThread.looper))
    }

    override fun stop() {
        Logger.i().print()
        mContext.unregisterReceiver(mBroadcastReceiver)
    }
}