package org.findmykids.geo.data.repository.live.activity.huawei

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import com.huawei.hms.location.ActivityIdentificationResponse
import org.findmykids.geo.common.di.DIScopeHolder
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.repository.live.activity.ActivityFactory
import org.findmykids.geo.data.repository.live.activity.ActivityRepository
import javax.inject.Inject


internal class ActivityHuaweiReceiver : BroadcastReceiver() {
    @Inject
    lateinit var mActivityRepository: ActivityRepository

    override fun onReceive(context: Context, intent: Intent) {
        Logger.d().print()
        // di
        DIScopeHolder.createSessionScope().inject(this)
        ActivityIdentificationResponse.getDataFromIntent(intent)?.let { results ->
            Logger.d().addArg(results).with(this@ActivityHuaweiReceiver).print()
            mActivityRepository.send(ActivityFactory.create(results))
        }
    }
}