package org.findmykids.geo.data.model

import java.util.*


// TODO Зоны безопасности
data class ZoneEvent(
    val errorCode: Int,
    val geofenceTransition: Int,
    val location: Location,
    val geofences: List<Geofence>,
    val create: Date = Date()
) {
    override fun toString(): String {
        return "${this::class.java}(" +
                "${this::class.java.declaredFields[1].name}=$errorCode, " +
                "${this::class.java.declaredFields[3].name}=$geofenceTransition, " +
                "${this::class.java.declaredFields[4].name}=$location, " +
                "${this::class.java.declaredFields[2].name}=$geofences, " +
                "${this::class.java.declaredFields[0].name}=$create)"
    }


    data class Geofence(
        val requestId: String
    ) {
        override fun toString(): String {
            return "${this::class.java}(" +
                    "${this::class.java.declaredFields[0].name}=${requestId})"
        }
    }
}