package org.findmykids.geo.data.model

import java.util.*


/**
 * Геолокация которая должна будет отправлена на бэк
 */
data class SendGeoLocation(
    val create: Date,
    val session: Session,
    val location: Location,
    val locationDefineSessionIndex: Long,
    val locationDefineGlobalIndex: Long,
    val calculatedLocation: CalculatedLocation?,
    val gpsInfo: GpsInfo?,
    val activity: Activity?,
    val battery: Battery?,
    val wifi: Wifi?,
    val sendReason: String, // причина отправки
    val sendSessionIndex: Long, // номер отправки в текущей сесии
    val sendGlobalIndex: Long, // номер отправки за все время работы
    val extensions: MutableMap<String, String>
) {
    override fun toString(): String {
        return "${this::class.simpleName}(" +
                "${this::class.java.declaredFields[3].name}=$create, " +
                "${this::class.java.declaredFields[12].name}=$session, " +
                "${this::class.java.declaredFields[6].name}=$location, " +
                "${this::class.java.declaredFields[8].name}=$locationDefineSessionIndex, " +
                "${this::class.java.declaredFields[7].name}=$locationDefineGlobalIndex, " +
                "${this::class.java.declaredFields[2].name}=$calculatedLocation, " +
                "${this::class.java.declaredFields[5].name}=$gpsInfo, " +
                "${this::class.java.declaredFields[0].name}=$activity, " +
                "${this::class.java.declaredFields[1].name}=$battery, " +
                "${this::class.java.declaredFields[13].name}=$wifi, " +
                "${this::class.java.declaredFields[10].name}=$sendReason, " +
                "${this::class.java.declaredFields[11].name}=$sendSessionIndex, " +
                "${this::class.java.declaredFields[9].name}=$sendGlobalIndex, " +
                "${this::class.java.declaredFields[4].name}=$extensions)"
    }
}