package org.findmykids.geo.common.di

import android.content.Context
import org.findmykids.geo.api.extensions.GeoExtensions
import org.findmykids.geo.api.extensions.SessionExtensions
import org.findmykids.geo.common.di.platform.PlatformComponent
import org.findmykids.geo.common.di.platform.module.ExtensionsModule
import org.findmykids.geo.common.di.root.DaggerRootComponent
import org.findmykids.geo.common.di.root.RootComponent
import org.findmykids.geo.common.di.root.module.ContextModule
import org.findmykids.geo.common.di.session.SessionComponent
import org.findmykids.geo.common.di.session.module.DBModule


internal object DIScopeHolder {
    private var mRootComponent: RootComponent? = null
    private var mPlatformComponent: PlatformComponent? = null
    private var mSessionComponent: SessionComponent? = null


    override fun toString(): String = ""


    @Synchronized
    fun createRootScope(context: Context): RootComponent {
        if (mRootComponent == null) {
            mRootComponent = DaggerRootComponent.builder()
                .contextModule(ContextModule(context))
                .build()
        }
        return mRootComponent!!
    }


    @Synchronized
    fun createPlatformScope(context: Context, geoExtensions: GeoExtensions, sessionExtensions: SessionExtensions, appVersion: String): PlatformComponent {
        if (mPlatformComponent == null) {
            mPlatformComponent = createRootScope(context)
                .platformComponentBuilder()
                .extensionsModule(ExtensionsModule(geoExtensions, sessionExtensions, appVersion))
                .build()
        }
        return mPlatformComponent!!
    }


    @Synchronized
    fun createSessionScope(): SessionComponent {
        if (mSessionComponent == null) {
            mSessionComponent = mPlatformComponent!!
                .sessionComponentBuilder()
                .dBModule(DBModule(mRootComponent!!.context()))
                .build()
        }
        return mSessionComponent!!
    }

    @Synchronized
    fun clearSessionScope() {
        mSessionComponent = null
    }
}