/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.repository.live;

import android.os.Build;
import android.os.HandlerThread;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.BehaviorSubject;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.data.model.Configuration;
import org.findmykids.geo.data.repository.live.sensors.SensorsEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0004J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u000f2\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0004J\u0015\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u000bH$\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0017H$J\b\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/findmykids/geo/data/repository/live/BaseLiveRepository;", "C", "Lorg/findmykids/geo/data/model/Configuration;", "T", "", "()V", "mDataBehaviorSubject", "Lio/reactivex/subjects/BehaviorSubject;", "mErrorBehaviorSubject", "Lorg/findmykids/geo/common/GeoException;", "mHandlerThread", "Landroid/os/HandlerThread;", "isStarted", "", "observeErrors", "Lio/reactivex/Observable;", "observeEvents", "configuration", "(Lorg/findmykids/geo/data/model/Configuration;)Lio/reactivex/Observable;", "restart", "Lio/reactivex/Completable;", "(Lorg/findmykids/geo/data/model/Configuration;)Lio/reactivex/Completable;", "sendError", "", "geoException", "sendEvent", "t", "(Ljava/lang/Object;)V", "start", "handlerThread", "(Lorg/findmykids/geo/data/model/Configuration;Landroid/os/HandlerThread;)V", "stop", "toString", "", "geo_release"})
public abstract class BaseLiveRepository<C extends Configuration, T> {
    private BehaviorSubject<T> mDataBehaviorSubject;
    private BehaviorSubject<GeoException> mErrorBehaviorSubject;
    private HandlerThread mHandlerThread;

    @NotNull
    public String toString() {
        return "";
    }

    @NotNull
    public final Observable<T> observeEvents(@NotNull C configuration) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Observable observable = this.mDataBehaviorSubject.doOnSubscribe((Consumer)new Consumer<Disposable>(this, (Configuration)configuration){
            final /* synthetic */ BaseLiveRepository this$0;
            final /* synthetic */ Configuration $configuration;

            public final void accept(Disposable it) {
                Logger.INSTANCE.d("doOnSubscribe").with(this.this$0).print();
                if (!BaseLiveRepository.access$getMDataBehaviorSubject$p(this.this$0).hasObservers()) {
                    Logger.INSTANCE.d("start").with(this.this$0).print();
                    HandlerThread handlerThread = new HandlerThread("LiveDataThread");
                    BaseLiveRepository baseLiveRepository = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    HandlerThread $this$apply = handlerThread;
                    boolean bl3 = false;
                    $this$apply.start();
                    HandlerThread handlerThread2 = handlerThread;
                    BaseLiveRepository.access$setMHandlerThread$p(baseLiveRepository, handlerThread2);
                    HandlerThread handlerThread3 = BaseLiveRepository.access$getMHandlerThread$p(this.this$0);
                    if (handlerThread3 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.this$0.start(this.$configuration, handlerThread3);
                }
            }
            {
                this.this$0 = baseLiveRepository;
                this.$configuration = configuration;
            }
        }).doFinally(new Action(this){
            final /* synthetic */ BaseLiveRepository this$0;

            public final void run() {
                Logger.INSTANCE.d("doFinally").with(this.this$0).print();
                if (!BaseLiveRepository.access$getMDataBehaviorSubject$p(this.this$0).hasObservers()) {
                    Logger.INSTANCE.d("stop").with(this.this$0).print();
                    if (Build.VERSION.SDK_INT >= 18) {
                        HandlerThread handlerThread = BaseLiveRepository.access$getMHandlerThread$p(this.this$0);
                        if (handlerThread != null) {
                            handlerThread.quitSafely();
                        }
                    } else {
                        HandlerThread handlerThread = BaseLiveRepository.access$getMHandlerThread$p(this.this$0);
                        if (handlerThread != null) {
                            handlerThread.quit();
                        }
                    }
                    BaseLiveRepository.access$setMHandlerThread$p(this.this$0, null);
                    this.this$0.stop();
                }
            }
            {
                this.this$0 = baseLiveRepository;
            }
        }).doOnNext(new Consumer<T>(this){
            final /* synthetic */ BaseLiveRepository this$0;

            public final void accept(T it) {
                if (!(it instanceof SensorsEvent)) {
                    Logger.INSTANCE.d("doOnNext").addArg(it).with(this.this$0).print();
                }
            }
            {
                this.this$0 = baseLiveRepository;
            }
        }).observeOn(Schedulers.io());
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"mDataBehaviorSubject\n   \u2026bserveOn(Schedulers.io())");
        return observable;
    }

    @NotNull
    public final Observable<GeoException> observeErrors() {
        Observable observable = this.mErrorBehaviorSubject.doOnNext((Consumer)new Consumer<GeoException>(this){
            final /* synthetic */ BaseLiveRepository this$0;

            public final void accept(GeoException it) {
                GeoException geoException = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)geoException, (String)"it");
                Logger.INSTANCE.w(geoException).with(this.this$0).print();
            }
            {
                this.this$0 = baseLiveRepository;
            }
        }).observeOn(Schedulers.io());
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"mErrorBehaviorSubject\n  \u2026bserveOn(Schedulers.io())");
        return observable;
    }

    @NotNull
    public final Completable restart(@NotNull C configuration) {
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Completable completable = Completable.fromCallable((Callable)new Callable<Object>(this, (Configuration)configuration){
            final /* synthetic */ BaseLiveRepository this$0;
            final /* synthetic */ Configuration $configuration;

            public final void call() {
                Logger.d$default(Logger.INSTANCE, null, 1, null).with(this.this$0).print();
                if (BaseLiveRepository.access$getMDataBehaviorSubject$p(this.this$0).hasObservers()) {
                    this.this$0.stop();
                    HandlerThread handlerThread = BaseLiveRepository.access$getMHandlerThread$p(this.this$0);
                    if (handlerThread == null) {
                        Intrinsics.throwNpe();
                    }
                    this.this$0.start(this.$configuration, handlerThread);
                }
            }
            {
                this.this$0 = baseLiveRepository;
                this.$configuration = configuration;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable\n        .fro\u2026)\n            }\n        }");
        return completable;
    }

    protected final void sendEvent(T t) {
        if (!(t instanceof SensorsEvent)) {
            Logger.i$default(Logger.INSTANCE, null, 1, null).addArg(t).with(this).print();
        }
        this.mDataBehaviorSubject.onNext(t);
    }

    protected final void sendError(@NotNull GeoException geoException) {
        Intrinsics.checkParameterIsNotNull((Object)geoException, (String)"geoException");
        Logger.INSTANCE.w(geoException).with(this).print();
        this.mErrorBehaviorSubject.onNext((Object)geoException);
    }

    protected final boolean isStarted() {
        return this.mDataBehaviorSubject.hasObservers();
    }

    protected abstract void start(@NotNull C var1, @NotNull HandlerThread var2);

    protected abstract void stop();

    public BaseLiveRepository() {
        BehaviorSubject behaviorSubject = BehaviorSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)behaviorSubject, (String)"BehaviorSubject.create()");
        this.mDataBehaviorSubject = behaviorSubject;
        BehaviorSubject behaviorSubject2 = BehaviorSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)behaviorSubject2, (String)"BehaviorSubject.create()");
        this.mErrorBehaviorSubject = behaviorSubject2;
    }

    public static final /* synthetic */ BehaviorSubject access$getMDataBehaviorSubject$p(BaseLiveRepository $this) {
        return $this.mDataBehaviorSubject;
    }

    public static final /* synthetic */ void access$setMDataBehaviorSubject$p(BaseLiveRepository $this, BehaviorSubject behaviorSubject) {
        $this.mDataBehaviorSubject = behaviorSubject;
    }

    public static final /* synthetic */ HandlerThread access$getMHandlerThread$p(BaseLiveRepository $this) {
        return $this.mHandlerThread;
    }

    public static final /* synthetic */ void access$setMHandlerThread$p(BaseLiveRepository $this, HandlerThread handlerThread) {
        $this.mHandlerThread = handlerThread;
    }
}

