package org.findmykids.geo.presentation.session.live

import io.reactivex.Observable
import org.findmykids.geo.domain.live.error.ErrorInteractor
import org.findmykids.geo.domain.live.location.LocationInteractor
import org.findmykids.geo.domain.live.locator.LocatorInteractor
import org.findmykids.geo.domain.live.remote.RemoteInteractor
import org.findmykids.geo.domain.live.timeout.TimeoutInteractor
import org.findmykids.geo.domain.model.InnerEvent
import javax.inject.Inject


internal class LiveFacadeImpl @Inject constructor(
    private val mRemoteInteractor: RemoteInteractor,
    private val mLocationInteractor: LocationInteractor,
    private val mLocatorInteractor: LocatorInteractor,
    private val mTimeoutInteractor: TimeoutInteractor,
    private val mErrorInteractor: ErrorInteractor
) : LiveFacade {

    override fun toString(): String = ""


    override fun start(): Observable<InnerEvent> = Observable
        .mergeArray(
            mLocationInteractor.update(),
            mLocatorInteractor.update(),
            mRemoteInteractor.update(),
            mTimeoutInteractor.update(),
            mErrorInteractor.update()
        )

    override fun stop(): Observable<InnerEvent> = Observable
        .just(InnerEvent.EndCurrentSession(InnerEvent.EndCurrentSession.EndSessionReason.Stop))
}