package org.findmykids.geo.domain.subscriber.timer

import io.reactivex.Completable
import org.findmykids.geo.data.repository.storage.configuration.ConfigurationRepository
import org.findmykids.geo.data.repository.trigger.timer.TimerManager
import javax.inject.Inject


internal class TimerSubscriberInteractorImpl @Inject constructor(
    private val mTimerAlarmManager: TimerManager,
    private val mTimerWorkManager: TimerManager,
    private val mConfigurationRepository: ConfigurationRepository
) : TimerSubscriberInteractor {

    override fun toString(): String = ""

    override fun subscribe(): Completable = mTimerAlarmManager
        .unsubscribe()
        .andThen(mConfigurationRepository.get())
        .flatMapCompletable { mTimerAlarmManager.subscribe(it.timerConfiguration) }
        .andThen(mTimerWorkManager.unsubscribe())
        .andThen(mConfigurationRepository.get())
        .flatMapCompletable { mTimerWorkManager.subscribe(it.timerConfiguration) }

    override fun unsubscribe(): Completable = mTimerAlarmManager
        .unsubscribe()
        .andThen(mTimerWorkManager.unsubscribe())

    override fun subscribeIfNeed(): Completable = mTimerAlarmManager
        .isSubscribed()
        .flatMapCompletable { isSubscribed ->
            if (isSubscribed) {
                Completable.complete()
            } else {
                mConfigurationRepository
                    .get()
                    .flatMapCompletable { mTimerAlarmManager.subscribe(it.timerConfiguration) }
            }
        }
        .andThen(mTimerWorkManager.isSubscribed())
        .flatMapCompletable { isSubscribed ->
            if (isSubscribed) {
                Completable.complete()
            } else {
                mConfigurationRepository
                    .get()
                    .flatMapCompletable { mTimerWorkManager.subscribe(it.timerConfiguration) }
            }
        }
}