package org.findmykids.geo.data.repository.trigger.timer.work

import android.content.Context
import androidx.work.PeriodicWorkRequestBuilder
import androidx.work.WorkManager
import io.reactivex.Completable
import io.reactivex.Single
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.Configuration
import org.findmykids.geo.data.preferences.LocalPreferences
import org.findmykids.geo.data.repository.trigger.timer.TimerManager
import java.util.concurrent.TimeUnit
import javax.inject.Inject


internal class TimerWorkManagerImpl @Inject constructor(
    private val mContext: Context,
    private val mLocalPreferences: LocalPreferences
) : TimerManager {

    override fun toString(): String = ""


    override fun isSubscribed(): Single<Boolean> = Single
        .fromCallable {
            Logger.d().with(this@TimerWorkManagerImpl).print()
            val uuid = mLocalPreferences.getTimerUUID()
            if (uuid != null) {
                val workInfo = WorkManager.getInstance(mContext).getWorkInfoById(uuid).get()
                workInfo != null
            } else {
                false
            }
        }
        .doOnSuccess {
            Logger.i().setResult(it).with(this@TimerWorkManagerImpl).print()
        }

    override fun subscribe(configuration: Configuration.TimerConfiguration): Completable = Single
        .fromCallable {
            Logger.d().addArg(configuration).with(this@TimerWorkManagerImpl).print()
            val work = PeriodicWorkRequestBuilder<TimerWorker>(configuration.delay, TimeUnit.MILLISECONDS)
                .setInitialDelay(configuration.delay, TimeUnit.MILLISECONDS)
                .build()
            mLocalPreferences.setTimerUUID(work.id)
            WorkManager.getInstance(mContext).enqueue(work)
            true
        }
        .doOnSuccess {
            Logger.i().setResult(it).with(this@TimerWorkManagerImpl).print()
        }
        .ignoreElement()

    override fun unsubscribe(): Completable = Single
        .fromCallable {
            Logger.d().with(this@TimerWorkManagerImpl).print()
            mLocalPreferences.getTimerUUID()?.let {
                WorkManager.getInstance(mContext).cancelWorkById(it)
                mLocalPreferences.setTimerUUID(null)
            }
            true
        }
        .doOnSuccess {
            Logger.i().setResult(it).with(this@TimerWorkManagerImpl).print()
        }
        .ignoreElement()
}