package org.findmykids.geo.data.repository.trigger.station

import com.google.android.gms.location.GeofencingEvent
import com.huawei.hms.location.GeofenceData
import org.findmykids.geo.data.model.StationEvent
import org.findmykids.geo.data.model.LocationSource
import org.findmykids.geo.data.repository.live.location.LocationFactory


internal object StationEventFactory {
    fun createFromGeofencingEvent(geofencingEvent: GeofencingEvent) = StationEvent(
        geofencingEvent.errorCode,
        LocationFactory.createLocation(geofencingEvent.triggeringLocation, LocationSource.GOOGLE_FUSED)
    )

    fun createFromGeofenceData(geofenceData: GeofenceData) = StationEvent(
        geofenceData.errorCode,
        LocationFactory.createLocation(geofenceData.convertingLocation, LocationSource.HUAWEI_FUSED)
    )
}