package org.findmykids.geo.data.repository.live.remote

import geocoreproto.ConfigAndroid
import org.findmykids.geo.data.model.Configuration
import org.findmykids.geo.data.model.Configurations


internal object ConfigurationsFactory {
    fun createConfigurations(config: ConfigAndroid): Configurations =
        Configurations(
            config.activityConfig.run {
                Configuration.ActivityConfiguration(
                    activities = activitiesValueList
                )
            },
            config.timerConfig.run {
                Configuration.TimerConfiguration(
                    delay = delay
                )
            },
            config.passiveConfig.run {
                Configuration.PassiveConfiguration(
                    priority = priority,
                    minTime = minTime,
                    minDistance = minDistance
                )
            },
            config.stationConfig.run {
                Configuration.StationConfiguration(
                    lowRadius = radius
                )
            },
            config.fusedDataConfig.run {
                Configuration.LocationDataConfiguration(
                    priority = priority,
                    interval = interval,
                    maxWaitTime = maxWaitTime,
                    fastestInterval = fastestInterval,
                    smallestDisplacement = smallestDisplacement,
                    restartDelay = restartDelay
                )
            },
            config.gpsDataConfig.run {
                Configuration.GpsDataConfiguration()
            },
            config.lbsDataConfig.run {
                Configuration.LbsDataConfiguration()
            },
            config.wifiDataConfig.run {
                Configuration.WifiDataConfiguration()
            },
            config.sensorsDataConfig.run {
                Configuration.SensorsDataConfiguration(
                    samplingPeriodUs = samplingPeriodUs
                )
            },
            Configuration.RemoteDataConfiguration(),
            config.timeoutDataConfig.run {
                Configuration.TimeoutDataConfiguration(
                    delay = delay,
                    restartDelay = restartDelay
                )
            },
            config.activityConfig.run {
                Configuration.ActivityDataConfiguration(
                    detectionIntervalMillis = detectionIntervalMillis
                )
            },
            Configuration.BatteryDataConfiguration(),
            config.fusedLiveConfig.run {
                Configuration.LocationLiveConfiguration(
                    geoCountDontStopCriteria = geoCountDontStopCriteria,
                    filterGeoCountTime = filterGeoCountTime,
                    distanceStopCriteria = distanceStopCriteria,
                    countNotSendedGeoSendCriteria = countNotSendedGeoSendCriteria,
                    distanceSendCriteria = distanceSendCriteria,
                    accuracySendCriteria = accuracySendCriteria,
                    accuracyDontStopCriteria = accuracyDontStopCriteria,
                    bearingChangeSendCriteria = bearingChangeSendCriteria
                )
            },
            Configuration.LocatorLiveConfiguration(),
            config.geoStorageConfig.run {
                Configuration.GeoStorageConfiguration(
                    offlineMaxCount = offlineMaxCount
                )
            },
            Configuration.ErrorStorageConfiguration()
        )
}