package org.findmykids.geo.data.db

import androidx.room.Database
import androidx.room.RoomDatabase
import org.findmykids.geo.data.db.dao.*
import org.findmykids.geo.data.db.model.*


@Database(
    entities = [GeoEntity::class, ConfigurationEntity::class, ZoneEntity::class, SendGeoLocationEntity::class, ErrorEntity::class],
    version = 12,
    exportSchema = false
)
internal abstract class GeoDatabase : RoomDatabase() {
    val lock = Any()

    abstract fun geosDao(): GeosDao

    abstract fun configurationsDao(): ConfigurationsDao

    abstract fun zonesDao(): ZonesDao

    abstract fun sendGeoLocationsDao(): SendGeoLocationsDao

    abstract fun errorsDao(): ErrorsDao
}