@file:Suppress("unused")

package org.findmykids.geo.api

import android.content.Context
import org.findmykids.geo.R
import org.findmykids.geo.api.extensions.EmptyGeoExtensions
import org.findmykids.geo.api.extensions.EmptySessionExtensions
import org.findmykids.geo.api.extensions.GeoExtensions
import org.findmykids.geo.api.extensions.SessionExtensions
import org.findmykids.geo.common.di.DIScopeHolder
import org.findmykids.geo.common.logger.DBLogSaver
import org.findmykids.geo.common.logger.FileLogSaver
import org.findmykids.geo.common.logger.LogBuilder
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.common.utils.ProcessUtil


/**
 * Настройки геоплатформы
 */
object GeoPlatformSettings {
    internal var mAppId = ""


    /**
     * Инициализация гео платформы
     * Инициализация пройдет только в процессе гео
     */
    @JvmStatic
    @JvmOverloads
    fun init(
        context: Context,
        appId: String,
        appVersion: String,
        geoExtensions: GeoExtensions = EmptyGeoExtensions(),
        sessionExtensions: SessionExtensions = EmptySessionExtensions()
    ): Boolean {
        mAppId = appId
        if (!checkProcess(context)) {
            return false
        }
        Logger.d().print()
        DIScopeHolder.createPlatformScope(context, geoExtensions, sessionExtensions, appVersion)
        Thread.setDefaultUncaughtExceptionHandler { _, throwable ->
            Logger.e(throwable).print()
        }
        return true
    }

    /**
     * Включение логов в LogCat
     */
    @JvmStatic
    fun enableLogs(context: Context) {
        if (!checkProcess(context)) {
            return
        }
        LogBuilder.enableLogs = true
        Logger.d().print()
    }

    /**
     * Включение записи логов в файл
     * Файл находится external_storage/Android/data/org.findmykids.child/cache/Logs/geo.log
     */
    @JvmStatic
    fun enableFileLogs(context: Context) {
        if (!checkProcess(context)) {
            return
        }
        Logger.d().print()
        FileLogSaver.init(context)
    }

    /**
     * Включение записи логов в бд
     * Осторожно!!! бд не чистится
     */
    @JvmStatic
    fun enableDBLogs(context: Context) {
        if (!checkProcess(context)) {
            return
        }
        Logger.d().print()
        DBLogSaver.init(context)
    }


    private fun checkProcess(context: Context): Boolean =
        ProcessUtil.getProcessName().endsWith(context.getString(R.string.geo_process))
}