/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.presentation.session.output;

import io.reactivex.CompletableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.data.model.GeoLocation;
import org.findmykids.geo.domain.authorization.AuthorizationInteractor;
import org.findmykids.geo.domain.model.InnerEvent;
import org.findmykids.geo.domain.subscriber.activity.ActivitySubscriberInteractor;
import org.findmykids.geo.domain.subscriber.passive.PassiveSubscriberInteractor;
import org.findmykids.geo.domain.subscriber.station.StationSubscriberInteractor;
import org.findmykids.geo.domain.subscriber.timer.TimerSubscriberInteractor;
import org.findmykids.geo.domain.subscriber.zones.ZonesSubscriberInteractor;
import org.findmykids.geo.presentation.session.output.EventFrontController;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/findmykids/geo/presentation/session/output/EventFrontControllerImpl;", "Lorg/findmykids/geo/presentation/session/output/EventFrontController;", "mAuthorizationInteractor", "Lorg/findmykids/geo/domain/authorization/AuthorizationInteractor;", "mTimerSubscriberInteractor", "Lorg/findmykids/geo/domain/subscriber/timer/TimerSubscriberInteractor;", "mPassiveSubscriberInteractor", "Lorg/findmykids/geo/domain/subscriber/passive/PassiveSubscriberInteractor;", "mZonesSubscriberInteractor", "Lorg/findmykids/geo/domain/subscriber/zones/ZonesSubscriberInteractor;", "mActivitySubscriberInteractor", "Lorg/findmykids/geo/domain/subscriber/activity/ActivitySubscriberInteractor;", "mStationSubscriberInteractor", "Lorg/findmykids/geo/domain/subscriber/station/StationSubscriberInteractor;", "(Lorg/findmykids/geo/domain/authorization/AuthorizationInteractor;Lorg/findmykids/geo/domain/subscriber/timer/TimerSubscriberInteractor;Lorg/findmykids/geo/domain/subscriber/passive/PassiveSubscriberInteractor;Lorg/findmykids/geo/domain/subscriber/zones/ZonesSubscriberInteractor;Lorg/findmykids/geo/domain/subscriber/activity/ActivitySubscriberInteractor;Lorg/findmykids/geo/domain/subscriber/station/StationSubscriberInteractor;)V", "isNeedStopService", "Lio/reactivex/Single;", "", "innerEvent", "Lorg/findmykids/geo/domain/model/InnerEvent;", "processEndCurrentSession", "processNewConfiguration", "processNewError", "processNewGeo", "processNewGeoLocation", "geoLocation", "Lorg/findmykids/geo/data/model/GeoLocation;", "processNewZones", "processStop", "toString", "", "geo_release"})
public final class EventFrontControllerImpl
implements EventFrontController {
    private final AuthorizationInteractor mAuthorizationInteractor;
    private final TimerSubscriberInteractor mTimerSubscriberInteractor;
    private final PassiveSubscriberInteractor mPassiveSubscriberInteractor;
    private final ZonesSubscriberInteractor mZonesSubscriberInteractor;
    private final ActivitySubscriberInteractor mActivitySubscriberInteractor;
    private final StationSubscriberInteractor mStationSubscriberInteractor;

    @NotNull
    public String toString() {
        return "";
    }

    @Override
    @NotNull
    public Single<Boolean> isNeedStopService(@NotNull InnerEvent innerEvent) {
        Single<Boolean> single;
        Intrinsics.checkParameterIsNotNull((Object)innerEvent, (String)"innerEvent");
        Logger.i$default(Logger.INSTANCE, null, 1, null).addArg(innerEvent).print();
        InnerEvent innerEvent2 = innerEvent;
        if (innerEvent2 instanceof InnerEvent.NewGeo) {
            single = this.processNewGeo();
        } else if (innerEvent2 instanceof InnerEvent.NewError) {
            single = this.processNewError();
        } else if (innerEvent2 instanceof InnerEvent.NewGeoLocation) {
            single = this.processNewGeoLocation(((InnerEvent.NewGeoLocation)innerEvent).getGeoLocation());
        } else if (innerEvent2 instanceof InnerEvent.NewZones) {
            single = this.processNewZones();
        } else if (innerEvent2 instanceof InnerEvent.NewConfigurations) {
            single = this.processNewConfiguration();
        } else if (innerEvent2 instanceof InnerEvent.EndCurrentSession) {
            single = this.processEndCurrentSession();
        } else if (Intrinsics.areEqual((Object)innerEvent2, (Object)InnerEvent.Stop.INSTANCE)) {
            single = this.processStop();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Single single2 = single.doOnSuccess((Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ EventFrontControllerImpl this$0;

            public final void accept(Boolean it) {
                Logger.d$default(Logger.INSTANCE, null, 1, null).with(this.this$0).setResult(it).print();
            }
            {
                this.this$0 = eventFrontControllerImpl;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single2, (String)"when (innerEvent) {\n    \u2026ult(it).print()\n        }");
        return single2;
    }

    private final Single<Boolean> processNewGeo() {
        Single single = Single.just((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(false)");
        return single;
    }

    private final Single<Boolean> processNewError() {
        Single single = Single.just((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(false)");
        return single;
    }

    private final Single<Boolean> processNewGeoLocation(GeoLocation geoLocation) {
        Single single = this.mStationSubscriberInteractor.subscribe(geoLocation.getLocation()).toSingleDefault((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"mStationSubscriberIntera\u2026  .toSingleDefault(false)");
        return single;
    }

    private final Single<Boolean> processNewZones() {
        Single single = this.mZonesSubscriberInteractor.subscribe().toSingleDefault((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"mZonesSubscriberInteract\u2026  .toSingleDefault(false)");
        return single;
    }

    private final Single<Boolean> processNewConfiguration() {
        Single single = this.mTimerSubscriberInteractor.subscribe().andThen((CompletableSource)this.mPassiveSubscriberInteractor.subscribe()).andThen((CompletableSource)this.mActivitySubscriberInteractor.subscribe()).toSingleDefault((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"mTimerSubscriberInteract\u2026  .toSingleDefault(false)");
        return single;
    }

    private final Single<Boolean> processEndCurrentSession() {
        Single single = this.mAuthorizationInteractor.isActivated().flatMap(new Function<T, SingleSource<? extends R>>(this){
            final /* synthetic */ EventFrontControllerImpl this$0;

            @NotNull
            public final Single<Boolean> apply(@NotNull Boolean isActivated) {
                Intrinsics.checkParameterIsNotNull((Object)isActivated, (String)"isActivated");
                return isActivated != false ? EventFrontControllerImpl.access$getMTimerSubscriberInteractor$p(this.this$0).subscribeIfNeed().andThen((CompletableSource)EventFrontControllerImpl.access$getMPassiveSubscriberInteractor$p(this.this$0).subscribeIfNeed()).andThen((CompletableSource)EventFrontControllerImpl.access$getMActivitySubscriberInteractor$p(this.this$0).subscribeIfNeed()).andThen((CompletableSource)EventFrontControllerImpl.access$getMZonesSubscriberInteractor$p(this.this$0).subscribeIfNeed()).toSingleDefault((Object)true) : Single.just((Object)true);
            }
            {
                this.this$0 = eventFrontControllerImpl;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"mAuthorizationInteractor\u2026)\n            }\n        }");
        return single;
    }

    private final Single<Boolean> processStop() {
        Single single = this.mTimerSubscriberInteractor.unsubscribe().andThen((CompletableSource)this.mPassiveSubscriberInteractor.unsubscribe()).andThen((CompletableSource)this.mActivitySubscriberInteractor.unsubscribe()).andThen((CompletableSource)this.mZonesSubscriberInteractor.unsubscribe()).andThen((CompletableSource)this.mStationSubscriberInteractor.unsubscribe()).toSingleDefault((Object)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"mTimerSubscriberInteract\u2026   .toSingleDefault(true)");
        return single;
    }

    @Inject
    public EventFrontControllerImpl(@NotNull AuthorizationInteractor mAuthorizationInteractor, @NotNull TimerSubscriberInteractor mTimerSubscriberInteractor, @NotNull PassiveSubscriberInteractor mPassiveSubscriberInteractor, @NotNull ZonesSubscriberInteractor mZonesSubscriberInteractor, @NotNull ActivitySubscriberInteractor mActivitySubscriberInteractor, @NotNull StationSubscriberInteractor mStationSubscriberInteractor) {
        Intrinsics.checkParameterIsNotNull((Object)mAuthorizationInteractor, (String)"mAuthorizationInteractor");
        Intrinsics.checkParameterIsNotNull((Object)mTimerSubscriberInteractor, (String)"mTimerSubscriberInteractor");
        Intrinsics.checkParameterIsNotNull((Object)mPassiveSubscriberInteractor, (String)"mPassiveSubscriberInteractor");
        Intrinsics.checkParameterIsNotNull((Object)mZonesSubscriberInteractor, (String)"mZonesSubscriberInteractor");
        Intrinsics.checkParameterIsNotNull((Object)mActivitySubscriberInteractor, (String)"mActivitySubscriberInteractor");
        Intrinsics.checkParameterIsNotNull((Object)mStationSubscriberInteractor, (String)"mStationSubscriberInteractor");
        this.mAuthorizationInteractor = mAuthorizationInteractor;
        this.mTimerSubscriberInteractor = mTimerSubscriberInteractor;
        this.mPassiveSubscriberInteractor = mPassiveSubscriberInteractor;
        this.mZonesSubscriberInteractor = mZonesSubscriberInteractor;
        this.mActivitySubscriberInteractor = mActivitySubscriberInteractor;
        this.mStationSubscriberInteractor = mStationSubscriberInteractor;
    }

    public static final /* synthetic */ TimerSubscriberInteractor access$getMTimerSubscriberInteractor$p(EventFrontControllerImpl $this) {
        return $this.mTimerSubscriberInteractor;
    }

    public static final /* synthetic */ PassiveSubscriberInteractor access$getMPassiveSubscriberInteractor$p(EventFrontControllerImpl $this) {
        return $this.mPassiveSubscriberInteractor;
    }

    public static final /* synthetic */ ActivitySubscriberInteractor access$getMActivitySubscriberInteractor$p(EventFrontControllerImpl $this) {
        return $this.mActivitySubscriberInteractor;
    }

    public static final /* synthetic */ ZonesSubscriberInteractor access$getMZonesSubscriberInteractor$p(EventFrontControllerImpl $this) {
        return $this.mZonesSubscriberInteractor;
    }
}

