/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.repository.live.sensors;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.data.model.Configuration;
import org.findmykids.geo.data.repository.live.sensors.SensorsEvent;
import org.findmykids.geo.data.repository.live.sensors.SensorsFactory;
import org.findmykids.geo.data.repository.live.sensors.SensorsRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u000eH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/findmykids/geo/data/repository/live/sensors/SensorsRepositoryImpl;", "Lorg/findmykids/geo/data/repository/live/sensors/SensorsRepository;", "Landroid/hardware/SensorEventListener;", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mCounter", "", "mRotationMatrixInv", "", "mSensors", "", "Landroid/hardware/Sensor;", "onAccuracyChanged", "", "sensor", "accuracy", "", "onSensorChanged", "event", "Landroid/hardware/SensorEvent;", "start", "configuration", "Lorg/findmykids/geo/data/model/Configuration$SensorsDataConfiguration;", "handlerThread", "Landroid/os/HandlerThread;", "stop", "toString", "", "Companion", "geo_release"})
public final class SensorsRepositoryImpl
extends SensorsRepository
implements SensorEventListener {
    private final List<Sensor> mSensors;
    private final float[] mRotationMatrixInv;
    private long mCounter;
    private final Context mContext;
    private static final int[] SENSOR_TYPES;
    public static final Companion Companion;

    @Override
    @NotNull
    public String toString() {
        return "";
    }

    public void onAccuracyChanged(@Nullable Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(@NotNull SensorEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        long l = this.mCounter;
        this.mCounter = l + 1L;
        if (l % (long)500 == 0L) {
            Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        }
        Sensor sensor = event.sensor;
        Intrinsics.checkExpressionValueIsNotNull((Object)sensor, (String)"event.sensor");
        switch (sensor.getType()) {
            case 10: {
                float[] linearAcceleration = new float[4];
                float[] absAcceleration = new float[4];
                System.arraycopy(event.values, 0, linearAcceleration, 0, event.values.length);
                Matrix.multiplyMV((float[])absAcceleration, (int)0, (float[])this.mRotationMatrixInv, (int)0, (float[])linearAcceleration, (int)0);
                this.sendEvent(new SensorsEvent(SensorsFactory.INSTANCE.create(absAcceleration)));
                break;
            }
            case 11: {
                float[] rotationMatrix = new float[16];
                SensorManager.getRotationMatrixFromVector((float[])rotationMatrix, (float[])event.values);
                Matrix.invertM((float[])this.mRotationMatrixInv, (int)0, (float[])rotationMatrix, (int)0);
                break;
            }
        }
    }

    @Override
    protected void start(@NotNull Configuration.SensorsDataConfiguration configuration, @NotNull HandlerThread handlerThread) {
        Sensor sensor;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)handlerThread, (String)"handlerThread");
        Logger.i$default(Logger.INSTANCE, null, 1, null).addArg(configuration).print();
        Object object = ContextCompat.getSystemService((Context)this.mContext, SensorManager.class);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ContextCompat.getSystemS\u2026sorManager::class.java)!!");
        SensorManager sensorManager = (SensorManager)object;
        for (int sensorType : SENSOR_TYPES) {
            if (sensorManager.getDefaultSensor(sensorType) == null) {
                continue;
            }
            this.mSensors.add(sensor);
        }
        if (this.mSensors.size() != SENSOR_TYPES.length) {
            this.sendError(new GeoException.SensorNoValidSensors());
        } else {
            Iterable $this$forEach$iv = this.mSensors;
            boolean $i$f$forEach = false;
            Object object2 = $this$forEach$iv.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                sensor = (Sensor)element$iv;
                boolean bl = false;
                sensorManager.registerListener((SensorEventListener)this, sensor, configuration.getSamplingPeriodUs(), new Handler(handlerThread.getLooper()));
            }
        }
    }

    @Override
    protected void stop() {
        Logger.i$default(Logger.INSTANCE, null, 1, null).print();
        Object object = ContextCompat.getSystemService((Context)this.mContext, SensorManager.class);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ContextCompat.getSystemS\u2026sorManager::class.java)!!");
        SensorManager sensorManager = (SensorManager)object;
        Iterable $this$forEach$iv = this.mSensors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sensor it = (Sensor)element$iv;
            boolean bl = false;
            sensorManager.unregisterListener((SensorEventListener)this, it);
        }
        this.mSensors.clear();
    }

    @Inject
    public SensorsRepositoryImpl(@NotNull Context mContext) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        SensorsRepositoryImpl sensorsRepositoryImpl = this;
        boolean bl = false;
        sensorsRepositoryImpl.mSensors = list = (List)new ArrayList();
        this.mRotationMatrixInv = new float[16];
    }

    static {
        Companion = new Companion(null);
        SENSOR_TYPES = new int[]{10, 11};
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/findmykids/geo/data/repository/live/sensors/SensorsRepositoryImpl$Companion;", "", "()V", "SENSOR_TYPES", "", "geo_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

