/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.db.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.data.db.converter.ActivityTypesWithConfidencesMapConverter;
import org.findmykids.geo.data.db.converter.DateConverter;
import org.findmykids.geo.data.db.converter.GeoExceptionConverter;
import org.findmykids.geo.data.db.converter.SessionCommandsTypesListConverter;
import org.findmykids.geo.data.db.dao.ErrorsDao;
import org.findmykids.geo.data.db.model.ErrorEntity;
import org.findmykids.geo.data.model.ActivityType;
import org.findmykids.geo.data.model.CommandType;

public final class ErrorsDao_Impl
implements ErrorsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ErrorEntity> __insertionAdapterOfErrorEntity;
    private final DateConverter __dateConverter = new DateConverter();
    private final SessionCommandsTypesListConverter __sessionCommandsTypesListConverter = new SessionCommandsTypesListConverter();
    private final ActivityTypesWithConfidencesMapConverter __activityTypesWithConfidencesMapConverter = new ActivityTypesWithConfidencesMapConverter();
    private final GeoExceptionConverter __geoExceptionConverter = new GeoExceptionConverter();
    private final EntityDeletionOrUpdateAdapter<ErrorEntity> __deletionAdapterOfErrorEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public ErrorsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfErrorEntity = new EntityInsertionAdapter<ErrorEntity>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `ErrorEntity` (`id`,`create`,`sessionIndex`,`sessionCreate`,`sessionIsRealtime`,`sessionCommandsTypes`,`activityExist`,`activityElapsedRealtimeMillis`,`activityTime`,`activityActivitiesWithConfidences`,`batteryExist`,`batteryIsCharging`,`batteryLevel`,`geoException`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ErrorEntity value) {
                Integer _tmp_7;
                stmt.bindLong(1, (long)value.getId());
                long _tmp = ErrorsDao_Impl.this.__dateConverter.from(value.getCreate());
                stmt.bindLong(2, _tmp);
                stmt.bindLong(3, value.getSessionIndex());
                long _tmp_1 = ErrorsDao_Impl.this.__dateConverter.from(value.getSessionCreate());
                stmt.bindLong(4, _tmp_1);
                int _tmp_2 = value.getSessionIsRealtime() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_2);
                String _tmp_3 = ErrorsDao_Impl.this.__sessionCommandsTypesListConverter.from(value.getSessionCommandsTypes());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                int _tmp_4 = value.getActivityExist() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_4);
                if (value.getActivityElapsedRealtimeMillis() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, value.getActivityElapsedRealtimeMillis().longValue());
                }
                if (value.getActivityTime() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, value.getActivityTime().longValue());
                }
                String _tmp_5 = ErrorsDao_Impl.this.__activityTypesWithConfidencesMapConverter.from(value.getActivityActivitiesWithConfidences());
                if (_tmp_5 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_5);
                }
                int _tmp_6 = value.getBatteryExist() ? 1 : 0;
                stmt.bindLong(11, (long)_tmp_6);
                Integer n = value.getBatteryIsCharging() == null ? null : (_tmp_7 = Integer.valueOf(value.getBatteryIsCharging() != false ? 1 : 0));
                if (_tmp_7 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, (long)_tmp_7.intValue());
                }
                if (value.getBatteryLevel() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, (long)value.getBatteryLevel().intValue());
                }
                String _tmp_8 = ErrorsDao_Impl.this.__geoExceptionConverter.from(value.getGeoException());
                if (_tmp_8 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_8);
                }
            }
        };
        this.__deletionAdapterOfErrorEntity = new EntityDeletionOrUpdateAdapter<ErrorEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `ErrorEntity` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ErrorEntity value) {
                stmt.bindLong(1, (long)value.getId());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM ErrorEntity";
                return "DELETE FROM ErrorEntity";
            }
        };
    }

    @Override
    public void insert(ErrorEntity errorEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfErrorEntity.insert((Object)errorEntity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(ErrorEntity errorEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfErrorEntity.handle((Object)errorEntity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        String _sql = "SELECT COUNT(id) FROM ErrorEntity";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(id) FROM ErrorEntity", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ErrorEntity> selectOnline(long sessionIndex, long nowTime) {
        String _sql = "SELECT * FROM ErrorEntity WHERE sessionIndex = ? AND ? - sessionCreate < 60000";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ErrorEntity WHERE sessionIndex = ? AND ? - sessionCreate < 60000", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, sessionIndex);
        _argIndex = 2;
        _statement.bindLong(_argIndex, nowTime);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfCreate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"create");
            int _cursorIndexOfSessionIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionIndex");
            int _cursorIndexOfSessionCreate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionCreate");
            int _cursorIndexOfSessionIsRealtime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionIsRealtime");
            int _cursorIndexOfSessionCommandsTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionCommandsTypes");
            int _cursorIndexOfActivityExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityExist");
            int _cursorIndexOfActivityElapsedRealtimeMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityElapsedRealtimeMillis");
            int _cursorIndexOfActivityTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityTime");
            int _cursorIndexOfActivityActivitiesWithConfidences = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityActivitiesWithConfidences");
            int _cursorIndexOfBatteryExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"batteryExist");
            int _cursorIndexOfBatteryIsCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"batteryIsCharging");
            int _cursorIndexOfBatteryLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"batteryLevel");
            int _cursorIndexOfGeoException = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"geoException");
            ArrayList<ErrorEntity> _result = new ArrayList<ErrorEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                long _tmp = _cursor.getLong(_cursorIndexOfCreate);
                Date _tmpCreate = this.__dateConverter.to(_tmp);
                long _tmpSessionIndex = _cursor.getLong(_cursorIndexOfSessionIndex);
                long _tmp_1 = _cursor.getLong(_cursorIndexOfSessionCreate);
                Date _tmpSessionCreate = this.__dateConverter.to(_tmp_1);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfSessionIsRealtime);
                boolean _tmpSessionIsRealtime = _tmp_2 != 0;
                String _tmp_3 = _cursor.getString(_cursorIndexOfSessionCommandsTypes);
                List<CommandType> _tmpSessionCommandsTypes = this.__sessionCommandsTypesListConverter.to(_tmp_3);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfActivityExist);
                boolean _tmpActivityExist = _tmp_4 != 0;
                Long _tmpActivityElapsedRealtimeMillis = _cursor.isNull(_cursorIndexOfActivityElapsedRealtimeMillis) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfActivityElapsedRealtimeMillis));
                Long _tmpActivityTime = _cursor.isNull(_cursorIndexOfActivityTime) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfActivityTime));
                String _tmp_5 = _cursor.getString(_cursorIndexOfActivityActivitiesWithConfidences);
                Map<ActivityType, Integer> _tmpActivityActivitiesWithConfidences = this.__activityTypesWithConfidencesMapConverter.to(_tmp_5);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfBatteryExist);
                boolean _tmpBatteryExist = _tmp_6 != 0;
                Integer _tmp_7 = _cursor.isNull(_cursorIndexOfBatteryIsCharging) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfBatteryIsCharging));
                Boolean _tmpBatteryIsCharging = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                Integer _tmpBatteryLevel = _cursor.isNull(_cursorIndexOfBatteryLevel) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfBatteryLevel));
                String _tmp_8 = _cursor.getString(_cursorIndexOfGeoException);
                GeoException _tmpGeoException = this.__geoExceptionConverter.to(_tmp_8);
                ErrorEntity _item = new ErrorEntity(_tmpId, _tmpCreate, _tmpSessionIndex, _tmpSessionCreate, _tmpSessionIsRealtime, _tmpSessionCommandsTypes, _tmpActivityExist, _tmpActivityElapsedRealtimeMillis, _tmpActivityTime, _tmpActivityActivitiesWithConfidences, _tmpBatteryExist, _tmpBatteryIsCharging, _tmpBatteryLevel, _tmpGeoException);
                _result.add(_item);
            }
            ArrayList<ErrorEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ErrorEntity> select(int limit) {
        String _sql = "SELECT * FROM ErrorEntity LIMIT ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ErrorEntity LIMIT ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)limit);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfCreate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"create");
            int _cursorIndexOfSessionIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionIndex");
            int _cursorIndexOfSessionCreate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionCreate");
            int _cursorIndexOfSessionIsRealtime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionIsRealtime");
            int _cursorIndexOfSessionCommandsTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionCommandsTypes");
            int _cursorIndexOfActivityExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityExist");
            int _cursorIndexOfActivityElapsedRealtimeMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityElapsedRealtimeMillis");
            int _cursorIndexOfActivityTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityTime");
            int _cursorIndexOfActivityActivitiesWithConfidences = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityActivitiesWithConfidences");
            int _cursorIndexOfBatteryExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"batteryExist");
            int _cursorIndexOfBatteryIsCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"batteryIsCharging");
            int _cursorIndexOfBatteryLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"batteryLevel");
            int _cursorIndexOfGeoException = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"geoException");
            ArrayList<ErrorEntity> _result = new ArrayList<ErrorEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                long _tmp = _cursor.getLong(_cursorIndexOfCreate);
                Date _tmpCreate = this.__dateConverter.to(_tmp);
                long _tmpSessionIndex = _cursor.getLong(_cursorIndexOfSessionIndex);
                long _tmp_1 = _cursor.getLong(_cursorIndexOfSessionCreate);
                Date _tmpSessionCreate = this.__dateConverter.to(_tmp_1);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfSessionIsRealtime);
                boolean _tmpSessionIsRealtime = _tmp_2 != 0;
                String _tmp_3 = _cursor.getString(_cursorIndexOfSessionCommandsTypes);
                List<CommandType> _tmpSessionCommandsTypes = this.__sessionCommandsTypesListConverter.to(_tmp_3);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfActivityExist);
                boolean _tmpActivityExist = _tmp_4 != 0;
                Long _tmpActivityElapsedRealtimeMillis = _cursor.isNull(_cursorIndexOfActivityElapsedRealtimeMillis) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfActivityElapsedRealtimeMillis));
                Long _tmpActivityTime = _cursor.isNull(_cursorIndexOfActivityTime) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfActivityTime));
                String _tmp_5 = _cursor.getString(_cursorIndexOfActivityActivitiesWithConfidences);
                Map<ActivityType, Integer> _tmpActivityActivitiesWithConfidences = this.__activityTypesWithConfidencesMapConverter.to(_tmp_5);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfBatteryExist);
                boolean _tmpBatteryExist = _tmp_6 != 0;
                Integer _tmp_7 = _cursor.isNull(_cursorIndexOfBatteryIsCharging) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfBatteryIsCharging));
                Boolean _tmpBatteryIsCharging = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                Integer _tmpBatteryLevel = _cursor.isNull(_cursorIndexOfBatteryLevel) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfBatteryLevel));
                String _tmp_8 = _cursor.getString(_cursorIndexOfGeoException);
                GeoException _tmpGeoException = this.__geoExceptionConverter.to(_tmp_8);
                ErrorEntity _item = new ErrorEntity(_tmpId, _tmpCreate, _tmpSessionIndex, _tmpSessionCreate, _tmpSessionIsRealtime, _tmpSessionCommandsTypes, _tmpActivityExist, _tmpActivityElapsedRealtimeMillis, _tmpActivityTime, _tmpActivityActivitiesWithConfidences, _tmpBatteryExist, _tmpBatteryIsCharging, _tmpBatteryLevel, _tmpGeoException);
                _result.add(_item);
            }
            ArrayList<ErrorEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

