/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.db.converter;

import androidx.room.TypeConverter;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.data.model.Configuration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lorg/findmykids/geo/data/db/converter/ConfigurationConverter;", "", "()V", "fromConfiguration", "", "configuration", "Lorg/findmykids/geo/data/model/Configuration;", "toConfiguration", "jsonString", "Companion", "geo_release"})
public final class ConfigurationConverter {
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_OBJECT = "object";
    private static final Gson GSON;
    public static final Companion Companion;

    @TypeConverter
    @NotNull
    public final Configuration toConfiguration(@NotNull String jsonString) {
        Class clazz;
        Intrinsics.checkParameterIsNotNull((Object)jsonString, (String)"jsonString");
        JsonObject json = (JsonObject)GSON.fromJson(jsonString, JsonObject.class);
        JsonElement jsonElement = json.get(FIELD_TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"json.get(FIELD_TYPE)");
        int type = jsonElement.getAsInt();
        if (type == Configuration.Type.ACTIVITY.getValue()) {
            clazz = Configuration.ActivityConfiguration.class;
        } else if (type == Configuration.Type.PASSIVE.getValue()) {
            clazz = Configuration.PassiveConfiguration.class;
        } else if (type == Configuration.Type.STATION.getValue()) {
            clazz = Configuration.StationConfiguration.class;
        } else if (type == Configuration.Type.TIMER.getValue()) {
            clazz = Configuration.TimerConfiguration.class;
        } else if (type == Configuration.Type.LOCATION_DATA.getValue()) {
            clazz = Configuration.LocationDataConfiguration.class;
        } else if (type == Configuration.Type.GPS_DATA.getValue()) {
            clazz = Configuration.GpsDataConfiguration.class;
        } else if (type == Configuration.Type.BATTERY_DATA.getValue()) {
            clazz = Configuration.BatteryDataConfiguration.class;
        } else if (type == Configuration.Type.LBS_DATA.getValue()) {
            clazz = Configuration.LbsDataConfiguration.class;
        } else if (type == Configuration.Type.REMOTE_DATA.getValue()) {
            clazz = Configuration.RemoteDataConfiguration.class;
        } else if (type == Configuration.Type.SENSORS_DATA.getValue()) {
            clazz = Configuration.SensorsDataConfiguration.class;
        } else if (type == Configuration.Type.TIMEOUT_DATA.getValue()) {
            clazz = Configuration.TimeoutDataConfiguration.class;
        } else if (type == Configuration.Type.WIFI_DATA.getValue()) {
            clazz = Configuration.WifiDataConfiguration.class;
        } else if (type == Configuration.Type.ACTIVITY_DATA.getValue()) {
            clazz = Configuration.ActivityDataConfiguration.class;
        } else if (type == Configuration.Type.GEO_STORAGE.getValue()) {
            clazz = Configuration.GeoStorageConfiguration.class;
        } else if (type == Configuration.Type.ERROR_STORAGE.getValue()) {
            clazz = Configuration.ErrorStorageConfiguration.class;
        } else if (type == Configuration.Type.LOCATION_LIVE.getValue()) {
            clazz = Configuration.LocationLiveConfiguration.class;
        } else if (type == Configuration.Type.LOCATOR_LIVE.getValue()) {
            clazz = Configuration.LocatorLiveConfiguration.class;
        } else {
            throw (Throwable)new GeoException.InvalidConfigurationType(type);
        }
        Class<Configuration.ActivityConfiguration> cls = clazz;
        JsonElement jsonElement2 = json.get(FIELD_OBJECT);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"json.get(FIELD_OBJECT)");
        Object object = GSON.fromJson(jsonElement2.getAsString(), cls);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.findmykids.geo.data.model.Configuration");
        }
        return (Configuration)object;
    }

    @TypeConverter
    @NotNull
    public final String fromConfiguration(@NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        JsonObject json = new JsonObject();
        json.addProperty(FIELD_TYPE, (Number)configuration.getType());
        json.addProperty(FIELD_OBJECT, GSON.toJson((Object)configuration));
        String string2 = json.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"json.toString()");
        return string2;
    }

    static {
        Companion = new Companion(null);
        GSON = new Gson();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/findmykids/geo/data/db/converter/ConfigurationConverter$Companion;", "", "()V", "FIELD_OBJECT", "", "FIELD_TYPE", "GSON", "Lcom/google/gson/Gson;", "geo_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

