package org.findmykids.geo.domain.session

import io.reactivex.Completable
import org.findmykids.geo.domain.model.Command


/**
 * Работает с переменными сессии
 */
internal interface SessionInteractor {
    /**
     * Добавляет команды
     */
    fun addCommand(command: Command): Completable

    /**
     * Включает/отключает реалтайм из вне
     */
    fun setRealtime(enable: Boolean): Completable
}