package org.findmykids.geo.data.repository.storage.zones

import io.reactivex.Completable
import io.reactivex.Single
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.Zones
import org.findmykids.geo.data.db.GeoDatabase
import org.findmykids.geo.data.db.model.ZoneEntity
import javax.inject.Inject


internal class ZonesRepositoryImpl @Inject constructor(
    private val mGeoDatabase: GeoDatabase
) : ZonesRepository {

    override fun toString(): String = ""

    override fun get(): Single<Zones> = Single
        .fromCallable {
            Logger.d().with(this@ZonesRepositoryImpl).print()
            synchronized(mGeoDatabase.lock) {
                mGeoDatabase
                    .zonesDao()
                    .selectAll()
            }
        }
        .map { entities ->
            Logger.d().with(this@ZonesRepositoryImpl).print()
            Zones(entities.map {
                Zones.Zone(
                    it.id,
                    it.lat,
                    it.lon,
                    it.radius
                )
            })
        }
        .doOnSuccess {
            Logger.d().setResult(it).with(this@ZonesRepositoryImpl).print()
        }

    override fun set(zones: Zones): Completable = Completable
        .fromCallable {
            Logger.d().addArg(zones).with(this@ZonesRepositoryImpl).print()
            synchronized(mGeoDatabase.lock) {
                mGeoDatabase
                    .zonesDao()
                    .apply {
                        deleteAll()
                        zones.zones.forEach { insert(ZoneEntity(it.id, it.lat, it.lon, it.radius)) }
                    }
            }
        }
        .doOnComplete {
            Logger.d("Complete").with(this@ZonesRepositoryImpl).print()
        }

    override fun clear(): Completable = Completable
        .fromCallable {
            Logger.d().with(this@ZonesRepositoryImpl).print()
            synchronized(mGeoDatabase.lock) {
                mGeoDatabase
                    .zonesDao()
                    .deleteAll()
            }
        }
        .doOnComplete {
            Logger.d("Complete").with(this@ZonesRepositoryImpl).print()
        }
}