package org.findmykids.geo.data.repository.storage.error

import org.findmykids.geo.data.db.model.ErrorEntity
import org.findmykids.geo.data.model.Activity
import org.findmykids.geo.data.model.Battery
import org.findmykids.geo.data.model.Error
import org.findmykids.geo.data.model.Session


internal object ErrorFactory {
    fun create(errorEntity: ErrorEntity) = Error(
        errorEntity.create,
        Session(
            errorEntity.sessionIndex,
            errorEntity.sessionCreate,
            errorEntity.sessionIsRealtime,
            errorEntity.sessionCommandsTypes
        ),
        if (errorEntity.activityExist) {
            Activity(
                errorEntity.activityElapsedRealtimeMillis!!,
                errorEntity.activityTime!!,
                errorEntity.activityActivitiesWithConfidences!!
            )
        } else {
            null
        },
        if (errorEntity.batteryExist) {
            Battery(
                errorEntity.batteryIsCharging!!,
                errorEntity.batteryLevel!!
            )
        } else {
            null
        },
        errorEntity.geoException
    )
}