package org.findmykids.geo.data.repository.live.sensors

import android.os.Build
import android.os.SystemClock
import org.findmykids.geo.common.utils.DateTimeUtil
import org.findmykids.geo.data.model.Sensors


internal object SensorsFactory {
    fun create(absAcceleration: FloatArray): Sensors {
        val nowMs = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            DateTimeUtil.nanoToMilliseconds(SystemClock.elapsedRealtimeNanos())
        } else {
            DateTimeUtil.nanoToMilliseconds(SystemClock.elapsedRealtime())
        }
        return Sensors(
            listOf(
                absAcceleration[Sensors.NORTH],
                absAcceleration[Sensors.EAST],
                absAcceleration[Sensors.UP]
            ),
            nowMs
        )
    }
}