package org.findmykids.geo.data.db.converter

import androidx.room.TypeConverter
import com.google.gson.Gson
import com.google.gson.JsonObject
import org.findmykids.geo.common.GeoException


internal class GeoExceptionConverter {
    @TypeConverter
    fun to(geoException: String): GeoException {
        val json = GSON.fromJson(geoException, JsonObject::class.java)
        val cls = when (json.get(FIELD_TYPE).asString) {
            GeoException.ActivityTransitionNoPermission::class.java.canonicalName!! -> GeoException.ActivityTransitionNoPermission::class.java
            GeoException.ActivityTransitionSubscription::class.java.canonicalName!! -> GeoException.ActivityTransitionSubscription::class.java
            GeoException.ActivityTransitionUnSubscription::class.java.canonicalName!! -> GeoException.ActivityTransitionUnSubscription::class.java
            GeoException.PassiveNoPermission::class.java.canonicalName!! -> GeoException.PassiveNoPermission::class.java
            GeoException.PassiveSubscription::class.java.canonicalName!! -> GeoException.PassiveSubscription::class.java
            GeoException.PassiveUnSubscription::class.java.canonicalName!! -> GeoException.PassiveUnSubscription::class.java
            GeoException.ZoneSubscription::class.java.canonicalName!! -> GeoException.ZoneSubscription::class.java
            GeoException.ZoneUnSubscription::class.java.canonicalName!! -> GeoException.ZoneUnSubscription::class.java
            GeoException.StationSubscription::class.java.canonicalName!! -> GeoException.StationSubscription::class.java
            GeoException.StationUnSubscription::class.java.canonicalName!! -> GeoException.StationUnSubscription::class.java

            GeoException.ActivityNoPermission::class.java.canonicalName!! -> GeoException.ActivityNoPermission::class.java
            GeoException.ActivityStart::class.java.canonicalName!! -> GeoException.ActivityStart::class.java
            GeoException.ActivityStop::class.java.canonicalName!! -> GeoException.ActivityStop::class.java
            GeoException.ActivityRestart::class.java.canonicalName!! -> GeoException.ActivityRestart::class.java
            GeoException.GpsNoPermission::class.java.canonicalName!! -> GeoException.GpsNoPermission::class.java
            GeoException.GpsLocationManagerGpsIsNotEnabled::class.java.canonicalName!! -> GeoException.GpsLocationManagerGpsIsNotEnabled::class.java
            GeoException.GpsRestart::class.java.canonicalName!! -> GeoException.GpsRestart::class.java
            GeoException.LocationNoPermission::class.java.canonicalName!! -> GeoException.LocationNoPermission::class.java
            GeoException.LocationRestart::class.java.canonicalName!! -> GeoException.LocationRestart::class.java
            GeoException.GoogleFusedLocationManagerIsNotEnabled::class.java.canonicalName!! -> GeoException.GoogleFusedLocationManagerIsNotEnabled::class.java
            GeoException.GoogleFusedStart::class.java.canonicalName!! -> GeoException.GoogleFusedStart::class.java
            GeoException.GoogleFusedStop::class.java.canonicalName!! -> GeoException.GoogleFusedStop::class.java
            GeoException.HuaweiFusedLocationManagerIsNotEnabled::class.java.canonicalName!! -> GeoException.HuaweiFusedLocationManagerIsNotEnabled::class.java
            GeoException.HuaweiFusedStart::class.java.canonicalName!! -> GeoException.HuaweiFusedStart::class.java
            GeoException.HuaweiFusedStop::class.java.canonicalName!! -> GeoException.HuaweiFusedStop::class.java
            GeoException.GpsProviderLocationManagerGpsIsNotEnabled::class.java.canonicalName!! -> GeoException.GpsProviderLocationManagerGpsIsNotEnabled::class.java
            GeoException.SensorNoValidSensors::class.java.canonicalName!! -> GeoException.SensorNoValidSensors::class.java
            GeoException.TimeoutStart::class.java.canonicalName!! -> GeoException.TimeoutStart::class.java
            GeoException.TimeoutRestart::class.java.canonicalName!! -> GeoException.TimeoutRestart::class.java
            GeoException.WifiNoPermission::class.java.canonicalName!! -> GeoException.WifiNoPermission::class.java
            GeoException.WifiNotEnabled::class.java.canonicalName!! -> GeoException.WifiNotEnabled::class.java
            GeoException.WifiScanFailure::class.java.canonicalName!! -> GeoException.WifiScanFailure::class.java
            GeoException.WifiSchedule::class.java.canonicalName!! -> GeoException.WifiSchedule::class.java
            GeoException.WifiRestart::class.java.canonicalName!! -> GeoException.WifiRestart::class.java
            GeoException.LbsNoPermission::class.java.canonicalName!! -> GeoException.LbsNoPermission::class.java
            GeoException.LbsSchedule::class.java.canonicalName!! -> GeoException.LbsSchedule::class.java
            GeoException.LbsRestart::class.java.canonicalName!! -> GeoException.LbsRestart::class.java
            GeoException.InvalidLbsCellInfoType::class.java.canonicalName!! -> GeoException.InvalidLbsCellInfoType::class.java
            GeoException.InvalidSocketData::class.java.canonicalName!! -> GeoException.InvalidSocketData::class.java
            GeoException.InvalidSocketEvent::class.java.canonicalName!! -> GeoException.InvalidSocketEvent::class.java
            GeoException.Socket::class.java.canonicalName!! -> GeoException.Socket::class.java
            GeoException.SocketRestart::class.java.canonicalName!! -> GeoException.SocketRestart::class.java
            GeoException.SocketClose::class.java.canonicalName!! -> GeoException.SocketClose::class.java

            GeoException.InvalidLocatorGeo::class.java.canonicalName!! -> GeoException.InvalidLocatorGeo::class.java
            GeoException.EmptyLocation::class.java.canonicalName!! -> GeoException.EmptyLocation::class.java

            GeoException.InvalidGeoType::class.java.canonicalName!! -> GeoException.InvalidGeoType::class.java
            GeoException.InvalidConfigurationType::class.java.canonicalName!! -> GeoException.InvalidConfigurationType::class.java
            GeoException.InvalidCommandType::class.java.canonicalName!! -> GeoException.InvalidCommandType::class.java

            GeoException.YandexEmptyData::class.java.canonicalName!! -> GeoException.YandexEmptyData::class.java
            GeoException.YandexLocatorConnection::class.java.canonicalName!! -> GeoException.YandexLocatorConnection::class.java
            GeoException.YandexLocatorResponse::class.java.canonicalName!! -> GeoException.YandexLocatorResponse::class.java

            GeoException.NotSupportedAction::class.java.canonicalName!! -> GeoException.NotSupportedAction::class.java
            GeoException.Api::class.java.canonicalName!! -> GeoException.Api::class.java

            else -> throw Exception("Unknown exception")
        }
        return GSON.fromJson(json.get(FIELD_OBJECT).asString, cls) as GeoException
    }

    @TypeConverter
    fun from(geoException: GeoException): String {
        val json = JsonObject()
        json.addProperty(FIELD_TYPE, geoException.javaClass.canonicalName!!)
        json.addProperty(FIELD_OBJECT, GSON.toJson(geoException))
        return json.toString()
    }


    companion object {
        private const val FIELD_TYPE = "type"
        private const val FIELD_OBJECT = "object"

        private val GSON = Gson()
    }
}