package org.findmykids.geo.common.di.session.module

import android.content.Context
import com.huawei.hms.location.ActivityIdentification
import com.huawei.hms.location.LocationServices
import dagger.Module
import dagger.Provides
import org.findmykids.geo.common.di.session.SessionScope
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.common.utils.ManufactureUtil
import org.findmykids.geo.data.repository.trigger.activity.ActivityManager
import org.findmykids.geo.data.repository.trigger.activity.google.ActivityGoogleManagerImpl
import org.findmykids.geo.data.repository.trigger.activity.huawei.ActivityHuaweiManagerImpl
import org.findmykids.geo.data.repository.trigger.passive.PassiveManager
import org.findmykids.geo.data.repository.trigger.passive.googlefused.PassiveGoogleFusedManagerImpl
import org.findmykids.geo.data.repository.trigger.passive.huaweifused.PassiveHuaweiFusedManagerImpl
import org.findmykids.geo.data.repository.trigger.passive.locationmanager.PassiveLocationManagerManagerImpl
import org.findmykids.geo.data.repository.trigger.station.StationManager
import org.findmykids.geo.data.repository.trigger.station.google.StationGoogleManagerImpl
import org.findmykids.geo.data.repository.trigger.station.huawei.StationHuaweiManagerImpl
import org.findmykids.geo.data.repository.trigger.timer.TimerManager
import org.findmykids.geo.data.repository.trigger.timer.alarm.TimerAlarmManagerImpl
import org.findmykids.geo.data.repository.trigger.zones.ZonesManager
import org.findmykids.geo.data.repository.trigger.zones.google.ZonesGoogleManagerImpl
import org.findmykids.geo.data.repository.trigger.zones.huawei.ZonesHuaweiManagerImpl
import javax.inject.Named


@Module
internal class DataTriggerModule {
    init {
        Logger.d().print()
    }


    @Provides
    @SessionScope
    fun provideActivityManager(
        context: Context
    ): ActivityManager = if (ManufactureUtil.isHuawei() && ManufactureUtil.isEmuiVersion9_1orAfter()) {
        try {
            ActivityIdentification.getService(context)!!
            ActivityHuaweiManagerImpl(context)
        } catch (e: Exception) {
            ActivityGoogleManagerImpl(context)
        }
    } else {
        ActivityGoogleManagerImpl(context)
    }

    @Provides
    @SessionScope
    @Named("LocationManager")
    fun providePassiveLocationManagerAndroidManager(
        context: Context
    ): PassiveManager = PassiveLocationManagerManagerImpl(
        context
    )

    @Provides
    @SessionScope
    @Named("GoogleFused")
    fun providePassiveGoogleFusedManufactureManager(
        context: Context
    ): PassiveManager = PassiveGoogleFusedManagerImpl(
        context
    )

    @Provides
    @SessionScope
    @Named("HuaweiFused")
    fun providePassiveHuaweiFusedManufactureManager(
        context: Context
    ): PassiveManager = PassiveHuaweiFusedManagerImpl(
        context
    )

    @Provides
    @SessionScope
    fun provideStationManager(
        context: Context
    ): StationManager = if (ManufactureUtil.isHuawei() && ManufactureUtil.isEmuiVersion10orAfter()) {
        try {
            LocationServices.getGeofenceService(context)!!
            StationHuaweiManagerImpl(context)
        } catch (e: Exception) {
            StationGoogleManagerImpl(context)
        }
    } else {
        StationGoogleManagerImpl(context)
    }

    @Provides
    @SessionScope
    fun provideTimerAlarmManager(
        context: Context
    ): TimerManager = TimerAlarmManagerImpl(
        context
    )

    @Provides
    @SessionScope
    fun provideZonesManager(
        context: Context
    ): ZonesManager = if (ManufactureUtil.isHuawei() && ManufactureUtil.isEmuiVersion10orAfter()) {
        try {
            LocationServices.getGeofenceService(context)!!
            ZonesHuaweiManagerImpl(context)
        } catch (e: Exception) {
            ZonesGoogleManagerImpl(context)
        }
    } else {
        ZonesGoogleManagerImpl(context)
    }
}