/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.repository.trigger.station;

import android.location.Location;
import com.google.android.gms.location.GeofencingEvent;
import com.huawei.hms.location.GeofenceData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.data.model.LocationSource;
import org.findmykids.geo.data.model.StationEvent;
import org.findmykids.geo.data.repository.live.location.LocationFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/findmykids/geo/data/repository/trigger/station/StationEventFactory;", "", "()V", "createFromGeofenceData", "Lorg/findmykids/geo/data/model/StationEvent;", "geofenceData", "Lcom/huawei/hms/location/GeofenceData;", "createFromGeofencingEvent", "geofencingEvent", "Lcom/google/android/gms/location/GeofencingEvent;", "geo_release"})
public final class StationEventFactory {
    public static final StationEventFactory INSTANCE;

    @NotNull
    public final StationEvent createFromGeofencingEvent(@NotNull GeofencingEvent geofencingEvent) {
        Intrinsics.checkParameterIsNotNull((Object)geofencingEvent, (String)"geofencingEvent");
        int n = geofencingEvent.getErrorCode();
        Location location = geofencingEvent.getTriggeringLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)location, (String)"geofencingEvent.triggeringLocation");
        return new StationEvent(n, LocationFactory.INSTANCE.createLocation(location, LocationSource.GOOGLE_FUSED), null, 4, null);
    }

    @NotNull
    public final StationEvent createFromGeofenceData(@NotNull GeofenceData geofenceData) {
        Intrinsics.checkParameterIsNotNull((Object)geofenceData, (String)"geofenceData");
        int n = geofenceData.getErrorCode();
        Location location = geofenceData.getConvertingLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)location, (String)"geofenceData.convertingLocation");
        return new StationEvent(n, LocationFactory.INSTANCE.createLocation(location, LocationSource.HUAWEI_FUSED), null, 4, null);
    }

    private StationEventFactory() {
    }

    static {
        StationEventFactory stationEventFactory;
        INSTANCE = stationEventFactory = new StationEventFactory();
    }
}

