/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.repository.storage.error;

import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.data.db.model.ErrorEntity;
import org.findmykids.geo.data.model.Activity;
import org.findmykids.geo.data.model.ActivityType;
import org.findmykids.geo.data.model.Battery;
import org.findmykids.geo.data.model.Error;
import org.findmykids.geo.data.model.Session;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/findmykids/geo/data/repository/storage/error/ErrorFactory;", "", "()V", "create", "Lorg/findmykids/geo/data/model/Error;", "errorEntity", "Lorg/findmykids/geo/data/db/model/ErrorEntity;", "geo_release"})
public final class ErrorFactory {
    public static final ErrorFactory INSTANCE;

    @NotNull
    public final Error create(@NotNull ErrorEntity errorEntity) {
        Battery battery;
        Activity activity2;
        Intrinsics.checkParameterIsNotNull((Object)errorEntity, (String)"errorEntity");
        Date date = errorEntity.getCreate();
        Session session = new Session(errorEntity.getSessionIndex(), errorEntity.getSessionCreate(), errorEntity.getSessionIsRealtime(), errorEntity.getSessionCommandsTypes());
        if (errorEntity.getActivityExist()) {
            Long l = errorEntity.getActivityElapsedRealtimeMillis();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            long l2 = l;
            Long l3 = errorEntity.getActivityTime();
            if (l3 == null) {
                Intrinsics.throwNpe();
            }
            long l4 = l3;
            Map<ActivityType, Integer> map = errorEntity.getActivityActivitiesWithConfidences();
            if (map == null) {
                Intrinsics.throwNpe();
            }
            activity2 = new Activity(l2, l4, map);
        } else {
            activity2 = null;
        }
        if (errorEntity.getBatteryExist()) {
            Boolean bl = errorEntity.getBatteryIsCharging();
            if (bl == null) {
                Intrinsics.throwNpe();
            }
            boolean bl2 = bl;
            Integer n = errorEntity.getBatteryLevel();
            if (n == null) {
                Intrinsics.throwNpe();
            }
            battery = new Battery(bl2, n);
        } else {
            battery = null;
        }
        return new Error(date, session, activity2, battery, errorEntity.getGeoException());
    }

    private ErrorFactory() {
    }

    static {
        ErrorFactory errorFactory;
        INSTANCE = errorFactory = new ErrorFactory();
    }
}

