/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.repository.live.lbs;

import android.os.Build;
import android.telephony.CellIdentityGsm;
import android.telephony.CellIdentityLte;
import android.telephony.CellIdentityWcdma;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoNr;
import android.telephony.CellInfoTdscdma;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthWcdma;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.data.model.Lbs;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a8\u0006\n"}, d2={"Lorg/findmykids/geo/data/repository/live/lbs/LbsListFactory;", "", "()V", "createFromCellInfo", "Lorg/findmykids/geo/data/model/Lbs;", "cellInfo", "Landroid/telephony/CellInfo;", "createFromCellInfoList", "", "cellInfoList", "geo_release"})
@RequiresApi(value=17)
public final class LbsListFactory {
    public static final LbsListFactory INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Lbs> createFromCellInfoList(@NotNull List<? extends CellInfo> cellInfoList) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(cellInfoList, (String)"cellInfoList");
        Iterable $this$mapNotNull$iv = cellInfoList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Lbs lbs;
            Lbs lbs2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CellInfo it = (CellInfo)element$iv$iv;
            boolean bl2 = false;
            try {
                lbs2 = INSTANCE.createFromCellInfo(it);
            }
            catch (GeoException.InvalidLbsCellInfoType e) {
                lbs2 = null;
            }
            if (lbs2 == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Lbs it$iv$iv = lbs;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Lbs createFromCellInfo(CellInfo cellInfo) {
        Lbs lbs;
        if (cellInfo instanceof CellInfoGsm) {
            CellIdentityGsm cellIdentityGsm = ((CellInfoGsm)cellInfo).getCellIdentity();
            Intrinsics.checkExpressionValueIsNotNull((Object)cellIdentityGsm, (String)"cellInfo.cellIdentity");
            int n = cellIdentityGsm.getMcc();
            CellIdentityGsm cellIdentityGsm2 = ((CellInfoGsm)cellInfo).getCellIdentity();
            Intrinsics.checkExpressionValueIsNotNull((Object)cellIdentityGsm2, (String)"cellInfo.cellIdentity");
            int n2 = cellIdentityGsm2.getMnc();
            CellIdentityGsm cellIdentityGsm3 = ((CellInfoGsm)cellInfo).getCellIdentity();
            Intrinsics.checkExpressionValueIsNotNull((Object)cellIdentityGsm3, (String)"cellInfo.cellIdentity");
            int n3 = cellIdentityGsm3.getCid();
            CellIdentityGsm cellIdentityGsm4 = ((CellInfoGsm)cellInfo).getCellIdentity();
            Intrinsics.checkExpressionValueIsNotNull((Object)cellIdentityGsm4, (String)"cellInfo.cellIdentity");
            int n4 = cellIdentityGsm4.getLac();
            CellSignalStrengthGsm cellSignalStrengthGsm = ((CellInfoGsm)cellInfo).getCellSignalStrength();
            Intrinsics.checkExpressionValueIsNotNull((Object)cellSignalStrengthGsm, (String)"cellInfo.cellSignalStrength");
            lbs = new Lbs(n, n2, n3, n4, cellSignalStrengthGsm.getDbm());
        } else {
            if (cellInfo instanceof CellInfoCdma) {
                throw (Throwable)new GeoException.InvalidLbsCellInfoType(cellInfo);
            }
            if (cellInfo instanceof CellInfoLte) {
                CellIdentityLte cellIdentityLte = ((CellInfoLte)cellInfo).getCellIdentity();
                Intrinsics.checkExpressionValueIsNotNull((Object)cellIdentityLte, (String)"cellInfo.cellIdentity");
                int n = cellIdentityLte.getMcc();
                CellIdentityLte cellIdentityLte2 = ((CellInfoLte)cellInfo).getCellIdentity();
                Intrinsics.checkExpressionValueIsNotNull((Object)cellIdentityLte2, (String)"cellInfo.cellIdentity");
                int n5 = cellIdentityLte2.getMnc();
                CellIdentityLte cellIdentityLte3 = ((CellInfoLte)cellInfo).getCellIdentity();
                Intrinsics.checkExpressionValueIsNotNull((Object)cellIdentityLte3, (String)"cellInfo.cellIdentity");
                int n6 = cellIdentityLte3.getCi();
                CellIdentityLte cellIdentityLte4 = ((CellInfoLte)cellInfo).getCellIdentity();
                Intrinsics.checkExpressionValueIsNotNull((Object)cellIdentityLte4, (String)"cellInfo.cellIdentity");
                int n7 = cellIdentityLte4.getTac();
                CellSignalStrengthLte cellSignalStrengthLte = ((CellInfoLte)cellInfo).getCellSignalStrength();
                Intrinsics.checkExpressionValueIsNotNull((Object)cellSignalStrengthLte, (String)"cellInfo.cellSignalStrength");
                lbs = new Lbs(n, n5, n6, n7, cellSignalStrengthLte.getDbm());
            } else if (Build.VERSION.SDK_INT >= 18 && cellInfo instanceof CellInfoWcdma) {
                CellIdentityWcdma cellIdentityWcdma = ((CellInfoWcdma)cellInfo).getCellIdentity();
                Intrinsics.checkExpressionValueIsNotNull((Object)cellIdentityWcdma, (String)"cellInfo.cellIdentity");
                int n = cellIdentityWcdma.getMcc();
                CellIdentityWcdma cellIdentityWcdma2 = ((CellInfoWcdma)cellInfo).getCellIdentity();
                Intrinsics.checkExpressionValueIsNotNull((Object)cellIdentityWcdma2, (String)"cellInfo.cellIdentity");
                int n8 = cellIdentityWcdma2.getMnc();
                CellIdentityWcdma cellIdentityWcdma3 = ((CellInfoWcdma)cellInfo).getCellIdentity();
                Intrinsics.checkExpressionValueIsNotNull((Object)cellIdentityWcdma3, (String)"cellInfo.cellIdentity");
                int n9 = cellIdentityWcdma3.getCid();
                CellIdentityWcdma cellIdentityWcdma4 = ((CellInfoWcdma)cellInfo).getCellIdentity();
                Intrinsics.checkExpressionValueIsNotNull((Object)cellIdentityWcdma4, (String)"cellInfo.cellIdentity");
                int n10 = cellIdentityWcdma4.getLac();
                CellSignalStrengthWcdma cellSignalStrengthWcdma = ((CellInfoWcdma)cellInfo).getCellSignalStrength();
                Intrinsics.checkExpressionValueIsNotNull((Object)cellSignalStrengthWcdma, (String)"cellInfo.cellSignalStrength");
                lbs = new Lbs(n, n8, n9, n10, cellSignalStrengthWcdma.getDbm());
            } else {
                if (Build.VERSION.SDK_INT >= 29 && cellInfo instanceof CellInfoTdscdma) {
                    throw (Throwable)new GeoException.InvalidLbsCellInfoType(cellInfo);
                }
                if (Build.VERSION.SDK_INT >= 29 && cellInfo instanceof CellInfoNr) {
                    throw (Throwable)new GeoException.InvalidLbsCellInfoType(cellInfo);
                }
                throw (Throwable)new GeoException.InvalidLbsCellInfoType(cellInfo);
            }
        }
        return lbs;
    }

    private LbsListFactory() {
    }

    static {
        LbsListFactory lbsListFactory;
        INSTANCE = lbsListFactory = new LbsListFactory();
    }
}

