/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.db.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import org.findmykids.geo._todo.Geo;
import org.findmykids.geo._todo.GeoConverter;
import org.findmykids.geo.data.db.dao.GeosDao;
import org.findmykids.geo.data.db.model.GeoEntity;

public final class GeosDao_Impl
implements GeosDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<GeoEntity> __insertionAdapterOfGeoEntity;
    private final GeoConverter __geoConverter = new GeoConverter();
    private final EntityDeletionOrUpdateAdapter<GeoEntity> __deletionAdapterOfGeoEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public GeosDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfGeoEntity = new EntityInsertionAdapter<GeoEntity>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `GeoEntity` (`id`,`geo`) VALUES (nullif(?, 0),?)";
            }

            public void bind(SupportSQLiteStatement stmt, GeoEntity value) {
                stmt.bindLong(1, (long)value.getId());
                String _tmp = GeosDao_Impl.this.__geoConverter.fromGeo(value.getGeo());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
            }
        };
        this.__deletionAdapterOfGeoEntity = new EntityDeletionOrUpdateAdapter<GeoEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `GeoEntity` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, GeoEntity value) {
                stmt.bindLong(1, (long)value.getId());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM GeoEntity";
                return "DELETE FROM GeoEntity";
            }
        };
    }

    @Override
    public void insert(GeoEntity geoEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfGeoEntity.insert((Object)geoEntity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(GeoEntity geoEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfGeoEntity.handle((Object)geoEntity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoEntity> select(int limit) {
        String _sql = "SELECT * FROM GeoEntity LIMIT ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM GeoEntity LIMIT ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)limit);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfGeo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"geo");
            ArrayList<GeoEntity> _result = new ArrayList<GeoEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                String _tmp = _cursor.getString(_cursorIndexOfGeo);
                Geo _tmpGeo = this.__geoConverter.toGeo(_tmp);
                GeoEntity _item = new GeoEntity(_tmpId, _tmpGeo);
                _result.add(_item);
            }
            ArrayList<GeoEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

