/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.common.utils;

import android.annotation.SuppressLint;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import org.findmykids.geo.common.logger.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\n\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0003J\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\bH\u0007J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/findmykids/geo/common/utils/WifiUtil;", "", "()V", "FILE_ADDRESS_MAC", "", "MARSHMALLOW_MAC_ADDRESS", "getAddressMacByFile", "wifiMan", "Landroid/net/wifi/WifiManager;", "getAddressMacByInterface", "getCurrentLevel", "", "wifiManager", "(Landroid/net/wifi/WifiManager;)Ljava/lang/Integer;", "getCurrentMac", "getCurrentSsid", "connectivityManager", "Landroid/net/ConnectivityManager;", "geo_release"})
public final class WifiUtil {
    private static final String MARSHMALLOW_MAC_ADDRESS = "02:00:00:00:00:00";
    private static final String FILE_ADDRESS_MAC = "/sys/class/net/wlan0/address";
    public static final WifiUtil INSTANCE;

    @Nullable
    public final Integer getCurrentLevel(@NotNull WifiManager wifiManager) {
        Intrinsics.checkParameterIsNotNull((Object)wifiManager, (String)"wifiManager");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        return wifiInfo != null ? Integer.valueOf(wifiInfo.getRssi()) : null;
    }

    @Nullable
    public final String getCurrentSsid(@NotNull ConnectivityManager connectivityManager, @NotNull WifiManager wifiManager) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)connectivityManager, (String)"connectivityManager");
        Intrinsics.checkParameterIsNotNull((Object)wifiManager, (String)"wifiManager");
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
        if (networkInfo != null) {
            NetworkInfo networkInfo2 = networkInfo;
            boolean bl = false;
            boolean bl2 = false;
            NetworkInfo networkInfo3 = networkInfo2;
            boolean bl3 = false;
            if (networkInfo3.isConnected()) {
                WifiInfo connectionInfo = wifiManager.getConnectionInfo();
                if (connectionInfo != null && !TextUtils.isEmpty((CharSequence)connectionInfo.getSSID())) {
                    String string2 = connectionInfo.getSSID();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"connectionInfo.ssid");
                    CharSequence charSequence = string2;
                    String string3 = "\"$";
                    boolean bl4 = false;
                    string3 = new Regex(string3);
                    String string4 = "";
                    boolean bl5 = false;
                    charSequence = string3.replace(charSequence, string4);
                    string3 = "^\"";
                    boolean bl6 = false;
                    string3 = new Regex(string3);
                    String string5 = "";
                    bl5 = false;
                    string = string3.replace(charSequence, string5);
                } else {
                    string = null;
                }
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    @SuppressLint(value={"HardwareIds"})
    @Nullable
    public final String getCurrentMac(@NotNull WifiManager wifiManager) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)wifiManager, (String)"wifiManager");
        if (wifiManager.isWifiEnabled()) {
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)wifiInfo, (String)"wifiManager.connectionInfo");
            WifiInfo wifiInfo2 = wifiInfo;
            if (Intrinsics.areEqual((Object)wifiInfo2.getMacAddress(), (Object)MARSHMALLOW_MAC_ADDRESS)) {
                String string2;
                try {
                    String string3 = this.getAddressMacByInterface();
                    if (string3 == null) {
                        string3 = this.getAddressMacByFile(wifiManager);
                    }
                    string2 = string3;
                }
                catch (Exception e) {
                    Logger.INSTANCE.e(e).print();
                    string2 = null;
                }
                string = string2;
            } else {
                string = wifiInfo2.getMacAddress();
            }
        } else {
            string = null;
        }
        return string;
    }

    @SuppressLint(value={"DefaultLocale"})
    private final String getAddressMacByInterface() {
        try {
            ArrayList<NetworkInterface> arrayList = Collections.list(NetworkInterface.getNetworkInterfaces());
            Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"Collections.list(Network\u2026e.getNetworkInterfaces())");
            List all = arrayList;
            for (NetworkInterface nif : all) {
                String string;
                Intrinsics.checkExpressionValueIsNotNull((Object)nif.getName(), (String)"nif.name");
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                if (!Intrinsics.areEqual((Object)string3, (Object)"wlan0")) continue;
                byte[] byArray = nif.getHardwareAddress();
                if (byArray == null) {
                    return "";
                }
                byte[] macBytes = byArray;
                StringBuilder builder = new StringBuilder();
                for (byte b : macBytes) {
                    String string4;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string5 = "%02X:";
                    Object[] objectArray = new Object[]{b};
                    StringBuilder stringBuilder = builder;
                    boolean bl2 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string5, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    stringBuilder.append(string4);
                }
                CharSequence charSequence = builder;
                int n = 0;
                if (charSequence.length() > 0) {
                    builder.deleteCharAt(builder.length() - 1);
                }
                return builder.toString();
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(e).print();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getAddressMacByFile(WifiManager wifiMan) throws Exception {
        String string;
        if (wifiMan.isWifiEnabled()) {
            String string2;
            File file = new File(FILE_ADDRESS_MAC);
            FileInputStream inputStream = new FileInputStream(file);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder builder = new StringBuilder();
                Ref.ObjectRef line = new Ref.ObjectRef();
                while (true) {
                    String string3 = reader.readLine();
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string3;
                    boolean bl3 = false;
                    line.element = it;
                    if (string3 == null) break;
                    builder.append((String)line.element).append('\n');
                }
                string2 = builder.toString();
            }
            catch (IOException e) {
                Logger.INSTANCE.e(e).print();
                string2 = null;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    Logger.INSTANCE.e(e).print();
                }
            }
            string = string2;
        } else {
            string = null;
        }
        return string;
    }

    private WifiUtil() {
    }

    static {
        WifiUtil wifiUtil;
        INSTANCE = wifiUtil = new WifiUtil();
    }
}

