/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.common.logger;

import android.annotation.SuppressLint;
import android.content.Context;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.logger.FileLogSaver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nJ\b\u0010\u0012\u001a\u00020\nH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/findmykids/geo/common/logger/FileLogSaver;", "", "()V", "mFileOutputStream", "Ljava/io/FileOutputStream;", "mLock", "mOutputStreamWriter", "Ljava/io/OutputStreamWriter;", "mSubject", "Lio/reactivex/subjects/PublishSubject;", "", "init", "", "context", "Landroid/content/Context;", "save", "tag", "text", "toString", "geo_release"})
public final class FileLogSaver {
    private static final Object mLock;
    private static final PublishSubject<String> mSubject;
    private static FileOutputStream mFileOutputStream;
    private static OutputStreamWriter mOutputStreamWriter;
    public static final FileLogSaver INSTANCE;

    @NotNull
    public String toString() {
        return "";
    }

    @SuppressLint(value={"CheckResult"})
    public final void init(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (mOutputStreamWriter != null) {
            return;
        }
        try {
            File file;
            StringBuilder stringBuilder = new StringBuilder();
            File file2 = context.getExternalCacheDir();
            if (file2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"context.externalCacheDir!!");
            File directory = new File(stringBuilder.append(file2.getAbsolutePath()).append("/Logs").toString());
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (!(file = new File(directory, "geo.log")).exists()) {
                file.createNewFile();
            }
            FileOutputStream fileOutputStream = mFileOutputStream = new FileOutputStream(file);
            if (fileOutputStream == null) {
                Intrinsics.throwNpe();
            }
            mOutputStreamWriter = new OutputStreamWriter(fileOutputStream);
            mSubject.observeOn(Schedulers.newThread()).doOnTerminate((Action)init.1.INSTANCE).subscribe((Consumer)init.2.INSTANCE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void save(@NotNull String tag, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        mSubject.onNext((Object)(tag + ' ' + text + '\n'));
    }

    private FileLogSaver() {
    }

    static {
        FileLogSaver fileLogSaver;
        INSTANCE = fileLogSaver = new FileLogSaver();
        mLock = new Object();
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create()");
        mSubject = publishSubject;
    }

    public static final /* synthetic */ OutputStreamWriter access$getMOutputStreamWriter$p(FileLogSaver $this) {
        FileLogSaver fileLogSaver = $this;
        return mOutputStreamWriter;
    }

    public static final /* synthetic */ void access$setMOutputStreamWriter$p(FileLogSaver $this, OutputStreamWriter outputStreamWriter) {
        FileLogSaver fileLogSaver = $this;
        mOutputStreamWriter = outputStreamWriter;
    }

    public static final /* synthetic */ FileOutputStream access$getMFileOutputStream$p(FileLogSaver $this) {
        FileLogSaver fileLogSaver = $this;
        return mFileOutputStream;
    }

    public static final /* synthetic */ void access$setMFileOutputStream$p(FileLogSaver $this, FileOutputStream fileOutputStream) {
        FileLogSaver fileLogSaver = $this;
        mFileOutputStream = fileOutputStream;
    }

    public static final /* synthetic */ Object access$getMLock$p(FileLogSaver $this) {
        FileLogSaver fileLogSaver = $this;
        return mLock;
    }
}

