/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.common.logger;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.logger.DBLogSaver;
import org.findmykids.geo.common.logger.LogDatabase;
import org.findmykids.geo.common.logger.LogEntity;
import org.findmykids.geo.common.logger.LogType;
import org.findmykids.geo.data.db.dao.LogsDao;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J6\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\b\u0010\u0018\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/findmykids/geo/common/logger/DBLogSaver;", "", "()V", "LOG_DB_NAME", "", "mLock", "mLogsDao", "Lorg/findmykids/geo/data/db/dao/LogsDao;", "mSubject", "Lio/reactivex/subjects/PublishSubject;", "Lorg/findmykids/geo/common/logger/LogEntity;", "init", "", "context", "Landroid/content/Context;", "save", "pid", "", "date", "type", "Lorg/findmykids/geo/common/logger/LogType;", "className", "methodName", "suffix", "toString", "geo_release"})
public final class DBLogSaver {
    private static final String LOG_DB_NAME = "LogGeoDatabase";
    private static final Object mLock;
    private static LogsDao mLogsDao;
    private static final PublishSubject<LogEntity> mSubject;
    public static final DBLogSaver INSTANCE;

    @NotNull
    public String toString() {
        return "";
    }

    @SuppressLint(value={"CheckResult"})
    public final void init(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (mLogsDao == null) {
            mLogsDao = ((LogDatabase)Room.databaseBuilder((Context)context, LogDatabase.class, (String)LOG_DB_NAME).setJournalMode(RoomDatabase.JournalMode.TRUNCATE).fallbackToDestructiveMigration().build()).logsDao();
            mSubject.observeOn(Schedulers.newThread()).subscribe((Consumer)init.1.INSTANCE);
        }
    }

    public final void save(long pid, @NotNull String date, @NotNull LogType type, @NotNull String className, @NotNull String methodName, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        LogEntity logEntity = new LogEntity(0, pid, date, "1.15", type.name(), className, methodName, suffix, 1, null);
        mSubject.onNext((Object)logEntity);
    }

    private DBLogSaver() {
    }

    static {
        DBLogSaver dBLogSaver;
        INSTANCE = dBLogSaver = new DBLogSaver();
        mLock = new Object();
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create()");
        mSubject = publishSubject;
    }

    public static final /* synthetic */ Object access$getMLock$p(DBLogSaver $this) {
        DBLogSaver dBLogSaver = $this;
        return mLock;
    }

    public static final /* synthetic */ LogsDao access$getMLogsDao$p(DBLogSaver $this) {
        DBLogSaver dBLogSaver = $this;
        return mLogsDao;
    }

    public static final /* synthetic */ void access$setMLogsDao$p(DBLogSaver $this, LogsDao logsDao) {
        DBLogSaver dBLogSaver = $this;
        mLogsDao = logsDao;
    }
}

