/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.common.di.root.module;

import android.content.Context;
import android.content.SharedPreferences;
import dagger.Module;
import dagger.Provides;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.data.preferences.LocalPreferences;
import org.findmykids.geo.data.preferences.LocalPreferencesImpl;
import org.findmykids.geo.data.repository.storage.authorisation.AuthorisationRepository;
import org.findmykids.geo.data.repository.storage.authorisation.AuthorisationRepositoryImpl;
import org.findmykids.geo.domain.authorization.AuthorizationInteractor;
import org.findmykids.geo.domain.authorization.AuthorizationInteractorImpl;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0011"}, d2={"Lorg/findmykids/geo/common/di/root/module/AuthorityModule;", "", "()V", "provideAuthorisationRepository", "Lorg/findmykids/geo/data/repository/storage/authorisation/AuthorisationRepository;", "localPreferences", "Lorg/findmykids/geo/data/preferences/LocalPreferences;", "provideAuthorizationInteractor", "Lorg/findmykids/geo/domain/authorization/AuthorizationInteractor;", "authorisationRepository", "provideLocalPreferences", "sharedPreferences", "Landroid/content/SharedPreferences;", "provideSharedPreferences", "context", "Landroid/content/Context;", "Companion", "geo_release"})
public final class AuthorityModule {
    private static final String SHARED_PREFERENCES_NAME = "GeoSharedPreferences";
    public static final Companion Companion = new Companion(null);

    @Provides
    @Singleton
    @NotNull
    public final SharedPreferences provideSharedPreferences(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context\n        .getShar\u2026ME, Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    @Provides
    @Singleton
    @NotNull
    public final LocalPreferences provideLocalPreferences(@NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)sharedPreferences, (String)"sharedPreferences");
        return new LocalPreferencesImpl(sharedPreferences);
    }

    @Provides
    @Singleton
    @NotNull
    public final AuthorisationRepository provideAuthorisationRepository(@NotNull LocalPreferences localPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)localPreferences, (String)"localPreferences");
        return new AuthorisationRepositoryImpl(localPreferences);
    }

    @Provides
    @Singleton
    @NotNull
    public final AuthorizationInteractor provideAuthorizationInteractor(@NotNull AuthorisationRepository authorisationRepository) {
        Intrinsics.checkParameterIsNotNull((Object)authorisationRepository, (String)"authorisationRepository");
        return new AuthorizationInteractorImpl(authorisationRepository);
    }

    public AuthorityModule() {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/findmykids/geo/common/di/root/module/AuthorityModule$Companion;", "", "()V", "SHARED_PREFERENCES_NAME", "", "geo_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

