package org.findmykids.geo.domain.subscriber.zones

import io.reactivex.Completable
import org.findmykids.geo.data.repository.trigger.zones.ZonesManager
import org.findmykids.geo.data.repository.storage.zones.ZonesRepository
import javax.inject.Inject


// TODO Зоны безопасности
internal class ZonesSubscriberInteractorImpl @Inject constructor(
    private val mZonesManager: ZonesManager,
    private val mZoneRepository: ZonesRepository
) : ZonesSubscriberInteractor {

    override fun toString(): String = ""

    override fun subscribe(): Completable = mZonesManager
        .unsubscribe()
        .andThen(mZoneRepository.get())
        .flatMapCompletable { mZonesManager.subscribe(it) }

    override fun unsubscribe(): Completable = mZonesManager
        .unsubscribe()
        .andThen(mZonesManager.unsubscribe())

    override fun subscribeIfNeed(): Completable = mZonesManager
        .isSubscribed()
        .flatMapCompletable { isSubscribed ->
            if (isSubscribed) {
                Completable.complete()
            } else {
                mZoneRepository
                    .get()
                    .flatMapCompletable { mZonesManager.subscribe(it) }
            }
        }
}