package org.findmykids.geo.domain.subscriber.activity

import io.reactivex.Completable
import org.findmykids.geo.data.repository.trigger.activity.ActivityManager
import org.findmykids.geo.data.repository.storage.configuration.ConfigurationRepository
import javax.inject.Inject


internal class ActivitySubscriberInteractorImpl @Inject constructor(
    private val mActivityManager: ActivityManager,
    private val mConfigurationRepository: ConfigurationRepository
) : ActivitySubscriberInteractor {

    override fun toString(): String = ""

    override fun subscribe(): Completable = mActivityManager
        .unsubscribe()
        .andThen(mConfigurationRepository.get())
        .flatMapCompletable { mActivityManager.subscribe(it.activityConfiguration) }

    override fun unsubscribe(): Completable = mActivityManager
        .unsubscribe()

    override fun subscribeIfNeed(): Completable = mActivityManager
        .isSubscribed()
        .flatMapCompletable { isTransitionSubscribed ->
            if (isTransitionSubscribed) {
                Completable.complete()
            } else {
                mConfigurationRepository
                    .get()
                    .flatMapCompletable { mActivityManager.subscribe(it.activityConfiguration) }
            }
        }
}