package org.findmykids.geo.domain.session

import io.reactivex.Completable
import org.findmykids.geo.data.repository.storage.currentSession.CurrentSessionRepository
import org.findmykids.geo.domain.model.Command
import javax.inject.Inject


internal class SessionInteractorImpl @Inject constructor(
    private val mCurrentSessionRepository: CurrentSessionRepository
) : SessionInteractor {

    override fun toString(): String = ""

    override fun addCommand(command: Command): Completable = mCurrentSessionRepository
        .addCommandType(command.type)

    override fun setRealtime(enable: Boolean): Completable = mCurrentSessionRepository
        .setRealtime(enable)
}