package org.findmykids.geo.data.repository.trigger.zones.huawei

import android.content.Context
import android.content.Intent
import com.huawei.hms.location.GeofenceData
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.repository.trigger.zones.BaseZonesReceiver
import org.findmykids.geo.data.repository.trigger.zones.ZoneEventFactory


// TODO Зоны безопасности
internal class ZonesHuaweiReceiver : BaseZonesReceiver() {
    override fun onReceive(context: Context, intent: Intent) {
        Logger.d().print()
        GeofenceData.getDataFromIntent(intent)?.let {
            Logger.d().addArg(it).with(this@ZonesHuaweiReceiver).print()
            send(context, ZoneEventFactory.createFromGeofenceData(it))
        }
    }
}