package org.findmykids.geo.data.repository.trigger.zones

import com.google.android.gms.location.GeofencingEvent
import com.huawei.hms.location.GeofenceData
import org.findmykids.geo.data.model.ZoneEvent
import org.findmykids.geo.data.model.LocationSource
import org.findmykids.geo.data.repository.live.location.LocationFactory


// TODO Зоны безопасности
internal object ZoneEventFactory {
    fun createFromGeofencingEvent(geofencingEvent: GeofencingEvent) = ZoneEvent(
        geofencingEvent.errorCode,
        geofencingEvent.geofenceTransition,
        LocationFactory.createLocation(geofencingEvent.triggeringLocation, LocationSource.GOOGLE_FUSED),
        geofencingEvent.triggeringGeofences.map {
            ZoneEvent.Geofence(it.requestId)
        }
    )

    fun createFromGeofenceData(geofenceData: GeofenceData) = ZoneEvent(
        geofenceData.errorCode,
        geofenceData.conversion,
        LocationFactory.createLocation(geofenceData.convertingLocation, LocationSource.HUAWEI_FUSED),
        geofenceData.convertingGeofenceList.map {
            ZoneEvent.Geofence(it.uniqueId)
        }
    )
}