package org.findmykids.geo.data.repository.trigger.timer.work

import android.content.Context
import android.content.Intent
import android.os.Build
import androidx.work.Worker
import androidx.work.WorkerParameters
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.common.utils.ProcessUtil
import org.findmykids.geo.presentation.session.SessionService


internal class TimerWorker(appContext: Context, workerParams: WorkerParameters) : Worker(appContext, workerParams) {
    override fun doWork(): Result {
        Logger.d().addArg(ProcessUtil.getProcessName()).print()
        val intent = Intent(applicationContext, SessionService::class.java)
        intent.action = ACTION_TIMER_WORK
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            applicationContext.startForegroundService(intent)
        } else {
            applicationContext.startService(intent)
        }
        return Result.success()
    }


    companion object {
        const val ACTION_TIMER_WORK = "ACTION_TIMER_WORK"
    }
}