package org.findmykids.geo.data.repository.trigger.timer.work

import android.content.ContentProvider
import android.content.ContentValues
import android.database.Cursor
import android.net.Uri
import androidx.work.Configuration
import androidx.work.WorkManager
import java.util.concurrent.Executors


internal class MultiProcessWorkManagerInitializer : ContentProvider() {

    override fun onCreate(): Boolean {
        val config = Configuration.Builder()
            .setJobSchedulerJobIdRange(90000000, 99999999)
            .setExecutor(Executors.newSingleThreadExecutor())
            .build()
        WorkManager.initialize(context!!.applicationContext, config)
        return true
    }

    override fun insert(uri: Uri, values: ContentValues?): Uri? = null

    override fun query(
        uri: Uri,
        projection: Array<out String>?,
        selection: String?,
        selectionArgs: Array<out String>?,
        sortOrder: String?
    ): Cursor? = null

    override fun update(uri: Uri, values: ContentValues?, selection: String?, selectionArgs: Array<out String>?): Int = 0

    override fun delete(uri: Uri, selection: String?, selectionArgs: Array<out String>?): Int = 0

    override fun getType(uri: Uri): String? = null
}