package org.findmykids.geo.data.repository.trigger.task

import android.content.Context
import android.content.Intent
import android.os.Build
import androidx.annotation.RequiresApi
import androidx.work.Worker
import androidx.work.WorkerParameters
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.common.utils.ProcessUtil
import org.findmykids.geo.presentation.session.SessionService


@RequiresApi(Build.VERSION_CODES.O)
internal class TaskWorker(
    appContext: Context,
    workerParams: WorkerParameters
) : Worker(appContext, workerParams) {

    override fun doWork(): Result {
        Logger.d().addArg(ProcessUtil.getProcessName()).print()
        val task = Tasks.valueOf(inputData.getString(TASK)!!)
        val intent = Intent(applicationContext, SessionService::class.java).apply {
            action = task.name
            when (task) {
                Tasks.ACTIVATE -> {
                    putExtra(Tasks.BASE_URL, inputData.getString(Tasks.BASE_URL)!!)
                    putExtra(Tasks.API_KEY, inputData.getString(Tasks.API_KEY)!!.toCharArray())
                    putExtra(Tasks.USER_TOKEN, inputData.getString(Tasks.USER_TOKEN)!!.toCharArray())
                    putExtra(Tasks.USER_ID, inputData.getString(Tasks.USER_ID)!!.toCharArray())
                }
                Tasks.REAL_TIME -> {
                    putExtra(Tasks.REAL_TIME_ENABLED, inputData.getBoolean(Tasks.REAL_TIME_ENABLED, false))
                }
                else -> {
                }
            }
        }
        applicationContext.startForegroundService(intent)
        return Result.success()
    }


    companion object {
        const val TASK = "TASK"
    }
}