package org.findmykids.geo.data.repository.trigger.station.google

import android.content.Context
import android.content.Intent
import com.google.android.gms.location.GeofencingEvent
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.repository.trigger.station.BaseStationReceiver
import org.findmykids.geo.data.repository.trigger.station.StationEventFactory


internal class StationGoogleReceiver : BaseStationReceiver() {
    override fun onReceive(context: Context, intent: Intent) {
        Logger.d().print()
        GeofencingEvent.fromIntent(intent)?.let {
            Logger.d().addArg(it).with(this@StationGoogleReceiver).print()
            send(context, StationEventFactory.createFromGeofencingEvent(it))
        }
    }
}