package org.findmykids.geo.data.repository.trigger.passive.googlefused

import android.content.Context
import android.content.Intent
import com.google.android.gms.location.LocationResult
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.LocationSource
import org.findmykids.geo.data.repository.live.location.LocationFactory
import org.findmykids.geo.data.repository.trigger.passive.BasePassiveReceiver


internal class PassiveGoogleFusedReceiver : BasePassiveReceiver() {
    override fun onReceive(context: Context, intent: Intent) {
        Logger.d().addArg(intent).print()
        LocationResult.extractResult(intent)?.lastLocation?.let {
            Logger.d().addArg(it).with(this@PassiveGoogleFusedReceiver).print()
            send(context, LocationFactory.createLocation(it, LocationSource.GOOGLE_FUSED))
        }
    }
}